/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.VocabularyRule;
import eu.dnetlib.validator.service.impls.rules.xml.CrisClass;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class XMLCrisClassVocabularyRule
extends VocabularyRule
implements XMLRule {
    private static final long serialVersionUID = 6697956781771512326L;
    public static final String SCHEME_ID = "scheme_id";

    public XMLCrisClassVocabularyRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        String[] aterms = this.pros.getProperty("terms").split(",");
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Record ID: " + this.getValObjId()));
        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Class Nodes Found: " + nodes.getLength()));
        this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Scheme_id to match: " + this.pros.getProperty(SCHEME_ID)));
        int success = 0;
        int all = 0;
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                CrisClass crisClass = this.getCrisClass(nodes.item(i));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class ID Value: " + crisClass.getClassId()));
                this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Internal Node Class Scheme ID Value: " + crisClass.getClassSchemeId()));
                if (!crisClass.getClassSchemeId().equalsIgnoreCase(this.pros.getProperty(SCHEME_ID))) continue;
                ++all;
                for (String term : aterms) {
                    if (!term.trim().equals(crisClass.getClassId().trim())) continue;
                    this.log.debug((Object)("XML CRIS Class Vocabulary Rule. Node: " + crisClass.getClassId().trim() + " matches with " + term));
                    ++success;
                    continue block4;
                }
                continue;
            }
            catch (DataException e) {
                this.log.error((Object)("error getting cris class" + (Object)((Object)e)));
            }
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success((String)successConditions, (int)success, (int)all);
    }

    private CrisClass getCrisClass(Node node) throws DataException {
        CrisClass retClass = new CrisClass();
        try {
            Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = newXmlDocument.createElement("root");
            newXmlDocument.appendChild(root);
            Node copyNode = newXmlDocument.importNode(node, true);
            root.appendChild(copyNode);
            this.printXmlDocument(newXmlDocument);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            retClass.setClassId((String)xPath.evaluate("//cfClassId/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setClassSchemeId((String)xPath.evaluate("//cfClassSchemeId/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setStartDate((String)xPath.evaluate("//cfStartDate/text()", newXmlDocument, XPathConstants.STRING));
            retClass.setEndDate((String)xPath.evaluate("//cfEndDate/text()", newXmlDocument, XPathConstants.STRING));
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)("error getting cris class" + e));
        }
        catch (XPathExpressionException e) {
            this.log.error((Object)("error getting cris class" + e));
        }
        return retClass;
    }

    private void printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        this.log.debug((Object)string);
    }
}

