/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class XMLNotConfusedFieldsRule
extends Rule
implements XMLRule {
    private static final long serialVersionUID = -6253009649310760559L;
    public static final String FIELDS = "fields";

    public XMLNotConfusedFieldsRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        ArrayList<NodeList> lnodelist = new ArrayList<NodeList>();
        try {
            String[] xpaths;
            for (String xpath : xpaths = this.pros.getProperty(FIELDS).split(",")) {
                lnodelist.add(tobj.getNodes(xpath.trim()));
            }
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        for (int i = 0; i < lnodelist.size(); ++i) {
            for (int k = 0; k < ((NodeList)lnodelist.get(i)).getLength(); ++k) {
                String val1 = ((NodeList)lnodelist.get(i)).item(k).getNodeValue();
                this.log.debug((Object)("XML Not Confused Fields Rule. Val1: " + val1));
                for (int j = i + 1; j < lnodelist.size(); ++j) {
                    for (int l = 0; l < ((NodeList)lnodelist.get(j)).getLength(); ++l) {
                        String val2 = ((NodeList)lnodelist.get(j)).item(l).getNodeValue();
                        this.log.debug((Object)("XML Not Confused Fields Rule. Val1: " + val2));
                        if (!val1.trim().equalsIgnoreCase(val2.trim())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

