/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.validator.commons.dao.DaoException;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.dao.rules.RuleStatus;
import eu.dnetlib.validator.commons.dao.rules.RulesDAO;
import eu.dnetlib.validator.commons.dao.tasks.TaskStored;
import eu.dnetlib.validator.commons.dao.tasks.TasksDAO;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorJobListener
implements JobListener {
    private static Logger logger = Logger.getLogger(ValidatorJobListener.class);
    private Integer jobSubmittedId;
    private String jobSubmittedUser;
    private TasksDAO tasksDao;
    private JobsDAO jobsDao;
    private RulesDAO rulesDao;
    private String validationType;
    private Set<Integer> blacklistRuleIds;
    private int objsValidated = 0;
    private int score = 0;
    private int internalJobsFinished = 0;
    private int internalJobsSum = 1;
    Map<String, Map<Integer, RuleStatus>> scoreMapPerGroupBy = new HashMap();
    private String valBaseUrl = null;
    private Map<Integer, Rule> ruleCacheMap = new HashMap();
    private String groupBy_xpath = null;

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext, Throwable t) throws ValidatorException {
        try {
            logger.error((Object)("Completed tasks for " + jobId + " (exception). Error: " + t.getMessage()));
            ArrayList<TaskStored> tasksStored = new ArrayList<TaskStored>();
            List groupBy_values = this.parseGroupByValues(record, this.groupBy_xpath);
            for (CompletedTask ctask : tasks) {
                TaskStored taskStored = new TaskStored();
                taskStored.setEnded(ctask.finished.toString());
                taskStored.setStarted(ctask.started.toString());
                taskStored.setJobId(this.jobSubmittedId.intValue());
                taskStored.setRecordIdentifier(ctask.valobjId);
                taskStored.setRuleId(ctask.ruleId);
                taskStored.setSuccess(ctask.success);
                taskStored.setStatus("finished");
                tasksStored.add(taskStored);
                logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Task-failed: rule " + ctask.ruleId + " on " + ctask.valobjId + " with success " + ctask.success + " ruleId: " + taskStored.getRuleId() + " error:" + t.getMessage()));
            }
            this.updateScoreMap(groupBy_values, tasksStored);
            if (this.objsValidated % 100 == 0) {
                this.jobsDao.setStatus(this.jobSubmittedId.intValue(), "ongoing", this.objsValidated, this.validationType);
            }
            ++this.objsValidated;
        }
        catch (Exception e) {
            logger.error((Object)"Error while proccessing results");
            throw new ValidatorException("Error while proccessing results", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext) throws ValidatorException {
        try {
            ArrayList veloList = new ArrayList();
            logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Updating Completed Tasks"));
            HashMap<Integer, Boolean> ruleIdsSuccess = new HashMap<Integer, Boolean>();
            HashMap<String, String> veloMap = null;
            ArrayList<TaskStored> tasksStored = new ArrayList<TaskStored>();
            List groupBy_values = this.parseGroupByValues(record, this.groupBy_xpath);
            int recordScore = -1;
            for (CompletedTask ctask : tasks) {
                veloMap = new HashMap<String, String>();
                TaskStored taskStored = new TaskStored();
                taskStored.setEnded(ctask.finished.toString());
                taskStored.setStarted(ctask.started.toString());
                taskStored.setJobId(this.jobSubmittedId.intValue());
                taskStored.setRecordIdentifier(ctask.valobjId);
                taskStored.setRuleId(ctask.ruleId);
                taskStored.setSuccess(ctask.success);
                taskStored.setStatus("finished");
                tasksStored.add(taskStored);
                ruleIdsSuccess.put(taskStored.getRuleId(), ctask.success);
                if (ctask.success) continue;
                veloMap.put("id", Integer.toString(taskStored.getRuleId()));
                veloMap.put("error", "...");
                veloList.add(veloMap);
                Rule rule = this.getRule(taskStored.getRuleId());
                String xpath = null;
                veloMap.put("name", rule.getName());
                xpath = !rule.getType().contains("Chain") ? rule.getConfiguration().getProperty("xpath") : this.getRule(Integer.parseInt(rule.getConfiguration().getProperty("rule_2"))).getConfiguration().getProperty("xpath");
                veloMap.put("xpath", xpath);
                veloMap.put("mandatory", Boolean.toString(rule.isMandatory()));
            }
            this.updateScoreMap(groupBy_values, tasksStored);
            int recordBlacklistScore = -1;
            if (recordScore == -1) {
                recordScore = this.calculateRecordScore(ruleIdsSuccess);
                if (this.blacklistRuleIds != null) {
                    recordBlacklistScore = this.calculateBlacklistRecordScore(ruleIdsSuccess, this.blacklistRuleIds);
                }
            }
            HashMap<String, String> recordValidationResult = new HashMap<String, String>();
            recordValidationResult.put("score", Integer.toString(this.score));
            recordValidationResult.put("id", tasks.get((int)0).valobjId);
            if (this.score > 0) {
                recordValidationResult.put("status", "pass");
            } else {
                recordValidationResult.put("status", "fail");
            }
            recordContext.put("veloList", veloList);
            recordContext.put("recordValidationResult", recordValidationResult);
            recordContext.put("score", this.score);
            recordContext.put("recordBlacklistScore", recordBlacklistScore);
            if (this.objsValidated % 100 == 0) {
                this.jobsDao.setStatus(this.jobSubmittedId.intValue(), "ongoing", this.objsValidated, this.validationType);
            }
            ++this.objsValidated;
        }
        catch (Exception e) {
            logger.error((Object)"Error while proccessing results");
            throw new ValidatorException("Error while proccessing results", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        try {
            ++this.internalJobsFinished;
            if (this.internalJobsFinished == this.internalJobsSum) {
                logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Set job finished"));
                jobContext.put("jobSubmittedId", (int)this.jobSubmittedId);
                jobContext.put("jobSubmittedUser", this.jobSubmittedUser);
                this.score = this.jobsDao.setJobFinished(this.jobSubmittedId.intValue(), this.scoreMapPerGroupBy, null, Boolean.valueOf(false), this.objsValidated, this.validationType);
                logger.debug((Object)("score_" + this.validationType + ": " + this.score));
                jobContext.put("score_" + this.validationType, this.score);
                this.tasksDao.saveTasks((Map)this.scoreMapPerGroupBy.get("all"));
                if (this.jobSubmittedUser.contains("Workflow")) {
                    this.jobsDao.setTotalJobFinished(jobId, null, Boolean.valueOf(false));
                }
            } else {
                logger.debug((Object)("JOBID:" + this.jobSubmittedId + "#Job finished. Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing successfull job");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            ++this.internalJobsFinished;
            if (this.internalJobsFinished == this.internalJobsSum) {
                logger.debug((Object)("JOBID:" + this.jobSubmittedId + "# Set job finished-failed"));
                jobContext.put("jobSubmittedId", (int)this.jobSubmittedId);
                jobContext.put("jobSubmittedUser", this.jobSubmittedUser);
                this.score = this.jobsDao.setJobFinished(this.jobSubmittedId.intValue(), this.scoreMapPerGroupBy, t.getMessage(), Boolean.valueOf(true), this.objsValidated, this.validationType);
                jobContext.put("score_" + this.validationType, 0);
                if (this.jobSubmittedUser.contains("Workflow")) {
                    this.jobsDao.setTotalJobFinished(jobId, t.getMessage(), Boolean.valueOf(true));
                }
            } else {
                logger.debug((Object)("JOBID:" + this.jobSubmittedId + "#Job finished. Waiting " + (this.internalJobsSum - this.internalJobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed job");
        }
    }

    private synchronized void updateScoreMap(List<String> groupBy_values, List<TaskStored> tasksStored) throws Exception {
        for (String groupBy : groupBy_values) {
            logger.debug((Object)("updating map for groupBy value: " + groupBy));
            HashMap<Integer, RuleStatus> scoreMapPerRule = null;
            scoreMapPerRule = (HashMap<Integer, RuleStatus>)this.scoreMapPerGroupBy.get(groupBy);
            if (scoreMapPerRule == null) {
                logger.debug((Object)("map for groupBy value: " + groupBy + " doesn't exist"));
                scoreMapPerRule = new HashMap<Integer, RuleStatus>();
            } else {
                logger.debug((Object)("map for groupBy value: " + groupBy + " exists"));
            }
            for (TaskStored task : tasksStored) {
                RuleStatus ruleSt = null;
                ruleSt = (RuleStatus)scoreMapPerRule.get(task.getRuleId());
                if (ruleSt == null) {
                    logger.debug((Object)("ruleStatus for rule with id : " + task.getRuleId() + " doesn't exist"));
                    ruleSt = new RuleStatus();
                }
                Rule rule = null;
                rule = (Rule)this.ruleCacheMap.get(task.getRuleId());
                if (rule == null) {
                    rule = (Rule)this.rulesDao.get(task.getRuleId());
                    this.ruleCacheMap.put(task.getRuleId(), rule);
                }
                ruleSt.setMandatory(rule.isMandatory());
                ruleSt.setWeight(rule.getWeight());
                ++ruleSt.total;
                if (task.getSuccess()) {
                    ++ruleSt.success;
                } else if (groupBy.equals("all") && ruleSt.getFailedTasks().size() < 10) {
                    ruleSt.getFailedTasks().add(task);
                }
                scoreMapPerRule.put(task.getRuleId(), ruleSt);
            }
            this.scoreMapPerGroupBy.put(groupBy, scoreMapPerRule);
        }
    }

    private int calculateRecordScore(Map<Integer, Boolean> ruleIdsSuccess) throws Exception {
        float score = 0.0f;
        float sum = 0.0f;
        float weights = 0.0f;
        for (Map.Entry<Integer, Boolean> entry : ruleIdsSuccess.entrySet()) {
            Rule rule = (Rule)this.ruleCacheMap.get(entry.getKey());
            if (rule.isMandatory()) {
                weights += (float)rule.getWeight();
                if (entry.getValue().booleanValue()) {
                    sum += (float)rule.getWeight();
                }
            }
            score = sum / weights * 100.0f;
        }
        return (int)score;
    }

    private int calculateBlacklistRecordScore(Map<Integer, Boolean> ruleIdsSuccess, Set<Integer> blacklistRuleIds) throws Exception {
        float score = 0.0f;
        float sum = 0.0f;
        float weights = 0.0f;
        for (Map.Entry<Integer, Boolean> entry : ruleIdsSuccess.entrySet()) {
            Rule rule = (Rule)this.ruleCacheMap.get(entry.getKey());
            if (rule.isMandatory() && blacklistRuleIds.contains(entry.getKey())) {
                weights += (float)rule.getWeight();
                if (entry.getValue().booleanValue()) {
                    sum += (float)rule.getWeight();
                }
            }
            score = sum / weights * 100.0f;
        }
        return (int)score;
    }

    private synchronized List<String> parseGroupByValues(Object record, String xpath) {
        ArrayList<String> groupBy_values = null;
        logger.debug((Object)("groupBy field: " + xpath));
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            NodeList rtl = (NodeList)xPath.evaluate(xpath + "/text()", record, XPathConstants.NODESET);
            groupBy_values = new ArrayList<String>();
            if (rtl.getLength() > 0) {
                for (int i = 0; i < rtl.getLength(); ++i) {
                    Node childNode = rtl.item(i);
                    groupBy_values.add(childNode.getNodeValue());
                    logger.debug((Object)("value: " + childNode.getNodeValue()));
                }
                groupBy_values.add("all");
            } else {
                groupBy_values.add("all");
            }
        }
        catch (XPathExpressionException e) {
            logger.error((Object)("error getting object" + e));
        }
        return groupBy_values;
    }

    private Rule getRule(int id) throws DaoException {
        Rule rule = null;
        rule = (Rule)this.ruleCacheMap.get(id);
        if (rule == null) {
            rule = (Rule)this.rulesDao.get(id);
            this.ruleCacheMap.put(id, rule);
        }
        return rule;
    }

    public Integer getJobSubmittedId() {
        return this.jobSubmittedId;
    }

    public void setJobSubmittedId(Integer jobSubmittedId) {
        this.jobSubmittedId = jobSubmittedId;
    }

    public String getJobSubmittedUser() {
        return this.jobSubmittedUser;
    }

    public void setJobSubmittedUser(String jobSubmittedUser) {
        this.jobSubmittedUser = jobSubmittedUser;
    }

    public String getGroupBy_xpath() {
        return this.groupBy_xpath;
    }

    public void setGroupBy_xpath(String groupBy_xpath) {
        this.groupBy_xpath = groupBy_xpath;
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public int getInternalJobsSum() {
        return this.internalJobsSum;
    }

    public void setInternalJobsSum(int internalJobsSum) {
        this.internalJobsSum = internalJobsSum;
    }

    public Map<String, Map<Integer, RuleStatus>> getScoreMapPerGroupBy() {
        return this.scoreMapPerGroupBy;
    }

    public void setScoreMapPerGroupBy(Map<String, Map<Integer, RuleStatus>> scoreMapPerGroupBy) {
        this.scoreMapPerGroupBy = scoreMapPerGroupBy;
    }

    public TasksDAO getTasksDao() {
        return this.tasksDao;
    }

    public void setTasksDao(TasksDAO tasksDao) {
        this.tasksDao = tasksDao;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }

    public RulesDAO getRulesDao() {
        return this.rulesDao;
    }

    public void setRulesDao(RulesDAO rulesDao) {
        this.rulesDao = rulesDao;
    }

    public Map<Integer, Rule> getRuleCacheMap() {
        return this.ruleCacheMap;
    }

    public void setRuleCacheMap(Map<Integer, Rule> ruleCacheMap) {
        this.ruleCacheMap = ruleCacheMap;
    }

    public String getValidationType() {
        return this.validationType;
    }

    public void setValidationType(String validationType) {
        this.validationType = validationType;
    }

    public Set<Integer> getBlacklistRuleIds() {
        return this.blacklistRuleIds;
    }

    public void setBlacklistRuleIds(Set<Integer> blacklistRuleIds) {
        this.blacklistRuleIds = blacklistRuleIds;
    }
}

