/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.oaipmh;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.ResultSet;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.providers.OAIPMHSinglePageVerbProvider;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NodeList;

public class OAIPMHDateGranularityRule
extends Rule {
    private static final long serialVersionUID = -3213680069275644769L;
    public static final String BASEURL = "base_url";

    public OAIPMHDateGranularityRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes("/OAI-PMH/ListIdentifiers/header/datestamp/text()");
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        Properties pros = new Properties();
        pros.setProperty("BASEURL", this.pros.getProperty(BASEURL));
        pros.setProperty("VERB", "Identify");
        OAIPMHSinglePageVerbProvider prv = new OAIPMHSinglePageVerbProvider();
        prv.setConfiguration(pros);
        try {
            ResultSet identify = prv.getValidationObjects();
            identify.next();
            XMLTextValidationObject xiden = (XMLTextValidationObject)identify.get();
            NodeList grns = xiden.getNodes("/OAI-PMH/Identify/granularity/text()");
            String granularity = grns.item(0).getNodeValue();
            this.log.debug((Object)("Date Granularity Rule. Granularity: " + granularity));
            ArrayList<String> regularExpressionValues = new ArrayList<String>();
            if (granularity.equals("YYYY-MM-DDThh:mm:ssZ")) {
                regularExpressionValues.add("\\d\\d\\d\\d[- /.](0[1-9]|1[012])[- /.](0[1-9]|[12][0-9]|3[01])T([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]Z");
            } else if (granularity.equals("YYYY-MM-DD")) {
                regularExpressionValues.add("\\d\\d\\d\\d[- /.](0[1-9]|1[012])[- /.](0[1-9]|[12][0-9]|3[01])");
                regularExpressionValues.add("\\d\\d\\d\\d");
                regularExpressionValues.add("\\d\\d\\d\\d[- /.](0[1-9]|1[012])");
            } else {
                return false;
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                String datestamp = nodes.item(i).getNodeValue();
                this.log.debug((Object)("Date Granularity Rule. Datestamp: " + datestamp));
                boolean matched = false;
                for (String regExpr : regularExpressionValues) {
                    Pattern pattern = Pattern.compile(regExpr);
                    Matcher matcher = pattern.matcher(datestamp);
                    if (!matcher.matches()) continue;
                    this.log.debug((Object)("Date Granularity Rule. Datestamp: " + datestamp + " (matched)"));
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            throw new RuleException(e.getMessage());
        }
    }
}

