/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.openaireAlerts;

import eu.dnetlib.broker.common.elasticsearch.AlertNotification;
import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.stats.OpenaireDsStat;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.objects.alerts.ValidatorAlertMessage;
import eu.dnetlib.broker.openaireAlerts.AlertSubscriptionDesc;
import eu.dnetlib.broker.openaireAlerts.AlertsPage;
import eu.dnetlib.broker.openaireAlerts.DatasourceWithAlert;
import eu.dnetlib.broker.openaireAlerts.OpenaireAlertsService;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Profile(value={"openaire"})
@RestController
@RequestMapping(value={"/api/openaire-alerts"})
@Tag(name="OpenAIRE Alerts")
public class OpenaireAlertsBrokerController
extends AbstractDnetController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private ElasticSearchProperties props;
    @Autowired
    private OpenaireAlertsService service;
    private static final Log log = LogFactory.getLog(OpenaireAlertsBrokerController.class);

    @Operation(summary="Return the datasources having alerts")
    @GetMapping(value={"/datasources-with-alerts"})
    public List<DatasourceWithAlert> findDatasourcesWithAlerts() {
        return this.service.findDatasourcesWithAlerts();
    }

    @Operation(summary="Perform a subscription")
    @PostMapping(value={"/subscribe/{compatibility}"})
    public Subscription registerSubscription(@PathVariable String compatibility, @RequestParam String email, @RequestParam String dsId) {
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new IllegalArgumentException("subscriber is empty");
        }
        return this.service.registerSubscription(email, dsId, OpenaireAlertsBrokerController.prepareTopicForCompatibility((String)compatibility));
    }

    protected static String prepareTopicForCompatibility(String compatibility) {
        return "ALERT/" + compatibility.replaceAll("\\s+", "").replaceAll("\\.", "_").toUpperCase();
    }

    @Operation(summary="Return the subscriptions of an user (by email and datasource (optional))")
    @GetMapping(value={"/subscriptions"})
    public List<AlertSubscriptionDesc> subscriptions(@RequestParam String email) {
        return this.service.listAlertSubscriptions(email);
    }

    private String extractDatasourceId(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> "datasourceId".equals(c.getField())).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().orElse("");
    }

    @Operation(summary="Return a page of alert notifications")
    @GetMapping(value={"/notifications/{subscrId}/{nPage}/{size}"})
    public AlertsPage notifications(@PathVariable String subscrId, @PathVariable int nPage, @PathVariable int size) {
        Optional optSub = this.service.findSubscription(subscrId);
        if (optSub.isPresent()) {
            Subscription sub = (Subscription)optSub.get();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termQuery((String)"subscriptionId.keyword", (String)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
            SearchHits page = this.esOperations.search((Query)searchQuery, AlertNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getAlertNotificationsIndexName()}));
            List list = page.stream().map(SearchHit::getContent).map(Notification::getPayload).map(ValidatorAlertMessage::fromJSON).collect(Collectors.toList());
            return new AlertsPage(this.extractDatasourceId(sub), sub.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new AlertsPage("", "", (long)nPage, 0L, 0L, new ArrayList());
    }

    @Operation(summary="Send notifications")
    @GetMapping(value={"/notifications/sendNotificationsForDatasource"})
    private List<String> sendNotificationsForDatasource(@RequestParam String dsId) {
        new Thread(() -> this.service.sendAlertNotifications(dsId)).start();
        return Arrays.asList("Sending ...");
    }

    @Operation(summary="Update stats")
    @PostMapping(value={"/stats/update"})
    public OpenaireDsStat updateStats(@RequestBody OpenaireDsStat stats) {
        return this.service.updateStats(stats);
    }

    @Operation(summary="Delete stats for a datasource")
    @GetMapping(value={"/stats/clearForDatasource"})
    public List<OpenaireDsStat> deleteStats(@RequestParam String dsId) {
        return this.service.deleteStats(dsId);
    }

    private long overrideGetTotalPage(SearchHits<?> page, int size) {
        return (page.getTotalHits() + (long)size - 1L) / (long)size;
    }
}

