/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.oa.controllers;

import com.google.gson.Gson;
import eu.dnetlib.broker.api.ShortEventMessage;
import eu.dnetlib.broker.common.elasticsearch.AlertNotification;
import eu.dnetlib.broker.common.elasticsearch.AlertNotificationRepository;
import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.elasticsearch.SuggestionEventRepository;
import eu.dnetlib.broker.common.elasticsearch.SuggestionNotification;
import eu.dnetlib.broker.common.elasticsearch.SuggestionNotificationRepository;
import eu.dnetlib.broker.common.feedbacks.DbEventFeedback;
import eu.dnetlib.broker.common.feedbacks.DbEventFeedbackRepository;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.stats.OpenaireDsStatRepository;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.oa.controllers.EventFeedback;
import eu.dnetlib.broker.oa.controllers.ScrollPage;
import eu.dnetlib.broker.objects.OaBrokerEventPayload;
import eu.dnetlib.broker.objects.alerts.ValidatorAlertMessage;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"openaire"})
@RestController
@RequestMapping(value={"/"})
@Tag(name="Openaire Broker Public API")
public class OpenairePublicController
extends AbstractDnetController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private SuggestionEventRepository suggestionEventRepository;
    @Autowired
    private SuggestionNotificationRepository suggestionNotificationRepository;
    @Autowired
    private AlertNotificationRepository alertNotificationRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private OpenaireDsStatRepository openaireDsStatRepository;
    @Autowired
    private DbEventFeedbackRepository feedbackRepository;
    @Autowired
    private ElasticSearchProperties props;
    @Value(value="${lbs.hadoop.opendoar.events.path}")
    private String opendoarEventsPath;
    private static final long SCROLL_TIMEOUT_IN_MILLIS = 300000L;
    private static final Log log = LogFactory.getLog(OpenairePublicController.class);

    @Operation(summary="Returns notifications by subscription using scrolls (first page)")
    @GetMapping(value={"/scroll/notifications/bySubscriptionId/{subscrId}"})
    public ScrollPage<ShortEventMessage> prepareScrollNotificationsBySubscrId(@PathVariable String subscrId) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (!optSub.isPresent()) {
            log.warn((Object)("Invalid subscription: " + subscrId));
            return new ScrollPage(null, true, new ArrayList());
        }
        ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
        String topic = ((Subscription)optSub.get()).getTopic();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termQuery((String)"subscriptionId.keyword", (String)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"topic", "payload", "eventId"}).withPageable((Pageable)PageRequest.of((int)0, (int)100)).build();
        SearchScrollHits scroll = topic.startsWith("ALERT/") ? esTemplate.searchScrollStart(300000L, (Query)searchQuery, AlertNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getAlertNotificationsIndexName()})) : esTemplate.searchScrollStart(300000L, (Query)searchQuery, SuggestionNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getSuggestionNotificationsIndexName()}));
        return this.generateScrollPage(esTemplate, scroll, topic.startsWith("ALERT/"));
    }

    @Operation(summary="Returns notifications using scrolls (other pages)")
    @GetMapping(value={"/scroll/notifications/{extendedScrollId}"})
    public ScrollPage<ShortEventMessage> scrollNotifications(@PathVariable String extendedScrollId) {
        ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
        SearchScrollHits scroll = extendedScrollId.startsWith("alert@@@") ? esTemplate.searchScrollContinue(StringUtils.substringAfter((String)extendedScrollId, (String)"alert@@@"), 300000L, AlertNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getAlertNotificationsIndexName()})) : esTemplate.searchScrollContinue(StringUtils.substringAfter((String)extendedScrollId, (String)"suggest@@@"), 300000L, SuggestionNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getSuggestionNotificationsIndexName()}));
        return this.generateScrollPage(esTemplate, scroll, extendedScrollId.startsWith("alert@@@"));
    }

    @Operation(summary="Returns notifications as file")
    @GetMapping(value={"/file/notifications/bySubscriptionId/{subscrId}"}, produces={"application/gzip"})
    public void notificationsAsFile(HttpServletResponse res, @PathVariable String subscrId) throws Exception {
        Gson gson = new Gson();
        res.setHeader("Content-Disposition", "attachment; filename=dump.json.gz");
        try (ServletOutputStream out = res.getOutputStream();
             GZIPOutputStream gzOut = new GZIPOutputStream((OutputStream)out);){
            boolean first = true;
            IOUtils.write((String)"[\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            ScrollPage page = null;
            do {
                page = page == null ? this.prepareScrollNotificationsBySubscrId(subscrId) : this.scrollNotifications(page.getId());
                for (ShortEventMessage msg : page.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        IOUtils.write((String)",\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
                    }
                    IOUtils.write((String)gson.toJson((Object)msg), (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
                }
            } while (!page.isCompleted());
            IOUtils.write((String)"\n]\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            gzOut.flush();
        }
    }

    @Operation(summary="Returns events as file by opendoarId")
    @GetMapping(value={"/file/events/opendoar/{id}"}, produces={"application/gzip"})
    public void opendoarEventsAsFile(HttpServletResponse res, @PathVariable String id) {
        res.setHeader("Content-Disposition", "attachment; filename=dump.json.gz");
        Configuration conf = new Configuration();
        conf.addResource(this.getClass().getResourceAsStream("/core-site.xml"));
        conf.addResource(this.getClass().getResourceAsStream("/ocean-hadoop-conf.xml"));
        Path pathDir = new Path(this.opendoarEventsPath + "/" + DigestUtils.md5Hex((String)id));
        try (FileSystem fs = FileSystem.get((Configuration)conf);
             ServletOutputStream out = res.getOutputStream();
             GZIPOutputStream gzOut = new GZIPOutputStream((OutputStream)out);){
            boolean first = true;
            IOUtils.write((String)"[\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            try {
                for (FileStatus fileStatus : fs.listStatus(pathDir)) {
                    Throwable throwable;
                    Throwable throwable2;
                    Throwable throwable3;
                    FSDataInputStream fis;
                    if (!fileStatus.isFile()) continue;
                    Path path = fileStatus.getPath();
                    if (path.getName().endsWith(".json")) {
                        fis = fs.open(path);
                        throwable3 = null;
                        try {
                            throwable2 = null;
                            try (InputStreamReader isr = new InputStreamReader((InputStream)fis);){
                                throwable = null;
                                try (BufferedReader br = new BufferedReader(isr);){
                                    first = this.processLine(gzOut, first, br);
                                    continue;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                            }
                            catch (Throwable br) {
                                throwable2 = br;
                                throw br;
                            }
                        }
                        catch (Throwable isr) {
                            throwable3 = isr;
                            throw isr;
                        }
                        finally {
                            if (fis != null) {
                                if (throwable3 != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable isr) {
                                        throwable3.addSuppressed(isr);
                                    }
                                } else {
                                    fis.close();
                                }
                            }
                        }
                    }
                    if (!path.getName().endsWith(".json.gz")) continue;
                    fis = fs.open(path);
                    throwable3 = null;
                    try {
                        throwable2 = null;
                        try (GZIPInputStream gzIn = new GZIPInputStream((InputStream)fis);){
                            throwable = null;
                            try (InputStreamReader isr = new InputStreamReader(gzIn);
                                 BufferedReader br = new BufferedReader(isr);){
                                first = this.processLine(gzOut, first, br);
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (fis != null) {
                            if (throwable3 != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                            } else {
                                fis.close();
                            }
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("File not found - " + e.getMessage()));
            }
            IOUtils.write((String)"\n]\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            gzOut.flush();
        }
        catch (Throwable e) {
            log.error((Object)"Error accessing hdfs file", e);
            throw new RuntimeException(e);
        }
    }

    private boolean processLine(GZIPOutputStream gzOut, boolean first, BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line != null) {
            if (first) {
                first = false;
            } else {
                IOUtils.write((String)",\n", (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            }
            IOUtils.write((String)line, (OutputStream)gzOut, (Charset)StandardCharsets.UTF_8);
            line = br.readLine();
        }
        return first;
    }

    @Operation(summary="Returns the list of subscriptions by user email")
    @GetMapping(value={"/subscriptions"})
    private Iterable<Subscription> listSubscriptionsByUser(@RequestParam String email) {
        return this.subscriptionRepo.findBySubscriber(email);
    }

    @Operation(summary="Returns the status of the application")
    @GetMapping(value={"/status"})
    private Map<String, Long> status() {
        LinkedHashMap<String, Long> res = new LinkedHashMap<String, Long>();
        res.put("n_subscriptions", this.subscriptionRepo.count());
        res.put("n_suggestion_events_es", this.suggestionEventRepository.count());
        res.put("n_suggestion_events_db", this.openaireDsStatRepository.totalEvents());
        res.put("n_suggestion_notifications", this.suggestionNotificationRepository.count());
        res.put("n_alert_notifications", this.alertNotificationRepository.count());
        return res;
    }

    @Operation(summary="Store the feedback of an event (MOCK)")
    @RequestMapping(value={"/feedback/events"}, method={RequestMethod.POST, RequestMethod.PATCH})
    private Map<String, Object> feedbackEvent(@RequestBody EventFeedback feedback) {
        DbEventFeedback dbEntry = new DbEventFeedback();
        dbEntry.setEventId(feedback.getEventId());
        dbEntry.setStatus(feedback.getStatus());
        this.feedbackRepository.save((Object)dbEntry);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("status", "done");
        res.put("feedback", dbEntry);
        return res;
    }

    private ScrollPage<ShortEventMessage> generateScrollPage(ElasticsearchRestTemplate esTemplate, SearchScrollHits<? extends Notification> scroll, boolean isAlert) {
        if (scroll.hasSearchHits()) {
            ScrollPage scrollPage = new ScrollPage();
            if (isAlert) {
                List values = this.calculateNotificationMessages(scroll, arg_0 -> this.messageFromAlertNotification(arg_0));
                scrollPage.setId("alert@@@" + scroll.getScrollId());
                scrollPage.setCompleted(values.isEmpty() || scroll.getScrollId() == null);
                scrollPage.setValues(values);
            } else {
                List values = this.calculateNotificationMessages(scroll, arg_0 -> this.messageFromNotification(arg_0));
                scrollPage.setId("suggest@@@" + scroll.getScrollId());
                scrollPage.setCompleted(values.isEmpty() || scroll.getScrollId() == null);
                scrollPage.setValues(values);
            }
            return scrollPage;
        }
        esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
        return new ScrollPage(null, true, new ArrayList());
    }

    private <T extends Notification> List<ShortEventMessage> calculateNotificationMessages(SearchScrollHits<T> scroll, Function<T, ShortEventMessage> messageFunction) {
        if (scroll.getSearchHits().size() > 0) {
            return scroll.stream().map(SearchHit::getContent).map(messageFunction).collect(Collectors.toList());
        }
        return new ArrayList<ShortEventMessage>();
    }

    private ShortEventMessage messageFromNotification(Notification n) {
        Gson gson = new Gson();
        OaBrokerEventPayload payload = (OaBrokerEventPayload)gson.fromJson(n.getPayload(), OaBrokerEventPayload.class);
        ShortEventMessage res = new ShortEventMessage();
        res.setEventId(n.getEventId());
        res.setOriginalId(payload.getResult().getOriginalId());
        res.setTitle((String)payload.getResult().getTitles().stream().filter(StringUtils::isNotBlank).findFirst().orElse(null));
        res.setTopic(n.getTopic());
        res.setTrust(payload.getTrust());
        res.generateMessageFromEventPayload(payload);
        return res;
    }

    private ShortEventMessage messageFromAlertNotification(Notification n) {
        Gson gson = new Gson();
        ValidatorAlertMessage payload = (ValidatorAlertMessage)gson.fromJson(n.getPayload(), ValidatorAlertMessage.class);
        ShortEventMessage res = new ShortEventMessage();
        res.setEventId(n.getEventId());
        res.setOriginalId(payload.getOriginalId());
        res.setTitle(null);
        res.setTopic(n.getTopic());
        res.setTrust(1.0f);
        res.generateMessageFromvValidatorAlertMessage(payload);
        return res;
    }
}

