/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.HdfsClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"dev"})
public class HdfsClientMock
implements HdfsClient {
    private static final Log log = LogFactory.getLog(HdfsClientMock.class);

    public String getHadoopUser() {
        return "DEV-USER";
    }

    public String getHadoopCluster() {
        return "MOCK-CLUSTER";
    }

    public String getHdfsBasePath() {
        return "/tmp";
    }

    public void deletePath(String path) throws MDStoreManagerException {
        throw new MDStoreManagerException("NOT IMPLEMENTED");
    }

    public Set<String> listHadoopDirs() {
        return new HashSet<String>();
    }

    public Set<String> listContent(String hdfsPath) {
        return new HashSet<String>();
    }

    public List<Map<String, String>> readParquetFiles(String hdfsPath, long limit) throws MDStoreManagerException {
        try {
            String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sample/sample.xml"), (Charset)StandardCharsets.UTF_8);
            String report = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sample/sample_report.json"), (Charset)StandardCharsets.UTF_8);
            return Stream.generate(UUID::randomUUID).map(UUID::toString).map(id -> {
                HashMap<String, String> reports = new HashMap<String, String>();
                reports.put("openaire4_0", report.replaceAll("__ORIGINAL_ID__", (String)id));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", "test________::" + DigestUtils.md5Hex((String)id));
                map.put("originalId", (String)id);
                map.put("body", xml.replaceAll("__ORIGINAL_ID__", (String)id));
                map.put("dateOfCollection", Long.toString(new Date().getTime()));
                map.put("encoding", "XML");
                map.put("provenance", "{\"datasourceId\": \"openaire____::TEST\", \"datasourceName\": \"TEST Datasource\", \"nsPrefix\": \"test________\"}");
                try {
                    map.put("validationResults", new ObjectMapper().writeValueAsString(reports));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                return map;
            }).limit(50L).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MDStoreManagerException((Throwable)e);
        }
    }
}

