/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.common;

import com.github.sisyphsu.dateparser.DateParserUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.MainEntityType;
import eu.dnetlib.dhp.schema.common.RelationInverse;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OriginDescription;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class ModelSupport {
    private static final Map<EntityType, MainEntityType> entityMapping = Maps.newHashMap();
    public static final Map<EntityType, Class> entityTypes;
    public static final Map<String, Class> oafTypes;
    public static final Map<Class, String> idPrefixMap;
    public static final Map<String, String> entityIdPrefix;
    public static final Map<String, String> idPrefixEntity;
    public static final Map<String, RelationInverse> relationInverseMap;
    private static final String schemeTemplate = "dnet:%s_%s_relations";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    private static void set(Map<String, RelationInverse> relationInverseMap, String relType, String subRelType, String relClass, String inverseRelClass) {
        relationInverseMap.put(ModelSupport.rel(relType, subRelType, relClass), new RelationInverse().setInverseRelClass(inverseRelClass).setRelClass(relClass).setRelType(relType).setSubReltype(subRelType));
        if (!relClass.equals(inverseRelClass)) {
            relationInverseMap.put(ModelSupport.rel(relType, subRelType, inverseRelClass), new RelationInverse().setInverseRelClass(relClass).setRelClass(inverseRelClass).setRelType(relType).setSubReltype(subRelType));
        }
    }

    public static RelationInverse findInverse(String encoding) {
        return relationInverseMap.entrySet().stream().filter(r -> encoding.equalsIgnoreCase((String)r.getKey())).findFirst().map(r -> (RelationInverse)r.getValue()).orElseThrow(() -> new IllegalArgumentException("invalid relationship: " + encoding));
    }

    public static RelationInverse findRelation(String relationName) {
        return relationInverseMap.values().stream().filter(r -> relationName.equalsIgnoreCase(r.getRelClass())).findFirst().orElse(null);
    }

    public static String rel(String relType, String subRelType, String relClass) {
        return String.format("%s_%s_%s", relType, subRelType, relClass);
    }

    private ModelSupport() {
    }

    public static <E> String getIdPrefix(Class<E> clazz) {
        return idPrefixMap.get(clazz);
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(X subClazzObject, Y superClazzObject) {
        return ModelSupport.isSubClass(subClazzObject.getClass(), superClazzObject.getClass());
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(X subClazzObject, Class<Y> superClazz) {
        return ModelSupport.isSubClass(subClazzObject.getClass(), superClazz);
    }

    public static <X extends Oaf, Y extends Oaf> Boolean isSubClass(Class<X> subClazz, Class<Y> superClazz) {
        return superClazz.isAssignableFrom(subClazz);
    }

    public static <T extends Oaf> Class<T>[] getOafModelClasses() {
        return new Class[]{Author.class, Context.class, Country.class, DataInfo.class, Dataset.class, Datasource.class, ExternalReference.class, ExtraInfo.class, Field.class, GeoLocation.class, Instance.class, AccessRight.class, OpenAccessRoute.class, Journal.class, KeyValue.class, Oaf.class, OafEntity.class, OAIProvenance.class, Organization.class, OriginDescription.class, OtherResearchProduct.class, Project.class, Publication.class, Qualifier.class, Relation.class, Result.class, Software.class, StructuredProperty.class};
    }

    public static String getMainType(EntityType type) {
        return entityMapping.get((Object)type).name();
    }

    public static boolean isResult(EntityType type) {
        return MainEntityType.result.name().equals(ModelSupport.getMainType(type));
    }

    public static String getScheme(String sourceType, String targetType) {
        return String.format(schemeTemplate, entityMapping.get((Object)EntityType.valueOf(sourceType)).name(), entityMapping.get((Object)EntityType.valueOf(targetType)).name());
    }

    public static <T extends Oaf> String tableIdentifier(String dbName, String tableName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dbName), (Object)"DB name cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"table name cannot be empty");
        return String.format("%s.%s", dbName, tableName);
    }

    public static <T extends Oaf> String tableIdentifier(String dbName, Class<T> clazz) {
        Preconditions.checkArgument((boolean)Objects.nonNull(clazz), (Object)"clazz is needed to derive the table name, thus cannot be null");
        return ModelSupport.tableIdentifier(dbName, clazz.getSimpleName().toLowerCase());
    }

    public static <T extends Oaf> Function<T, String> idFn() {
        return x -> {
            if (ModelSupport.isSubClass(x, Relation.class).booleanValue()) {
                return ModelSupport.idFnForRelation(x);
            }
            return ModelSupport.idFnForOafEntity(x);
        };
    }

    private static <T extends Oaf> String idFnForRelation(T t) {
        Relation r = (Relation)t;
        return Optional.ofNullable(r.getSource()).map(source -> Optional.ofNullable(r.getTarget()).map(target -> Optional.ofNullable(r.getRelType()).map(relType -> Optional.ofNullable(r.getSubRelType()).map(subRelType -> Optional.ofNullable(r.getRelClass()).map(relClass -> String.join((CharSequence)source, target, relType, subRelType, relClass)).orElse(String.join((CharSequence)source, target, relType, subRelType))).orElse(String.join((CharSequence)source, target, relType))).orElse(String.join((CharSequence)source, target))).orElse((String)source)).orElse(null);
    }

    private static <T extends Oaf> String idFnForOafEntity(T t) {
        return ((OafEntity)t).getId();
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String generateIdentifier(String originalId, String nsPrefix) {
        return String.format("%s::%s", nsPrefix, ModelSupport.md5(originalId));
    }

    public static String oldest(String dateA, String dateB) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateA)) {
            return dateB;
        }
        if (StringUtils.isBlank((CharSequence)dateB)) {
            return dateA;
        }
        if (StringUtils.isNotBlank((CharSequence)dateA) && StringUtils.isNotBlank((CharSequence)dateB)) {
            Date a = DateParserUtils.parseDate((String)dateA);
            Date b = DateParserUtils.parseDate((String)dateB);
            if (Objects.nonNull(a) && Objects.nonNull(b)) {
                return a.before(b) ? dateA : dateB;
            }
            return null;
        }
        return null;
    }

    static {
        entityMapping.put(EntityType.publication, MainEntityType.result);
        entityMapping.put(EntityType.dataset, MainEntityType.result);
        entityMapping.put(EntityType.otherresearchproduct, MainEntityType.result);
        entityMapping.put(EntityType.software, MainEntityType.result);
        entityMapping.put(EntityType.datasource, MainEntityType.datasource);
        entityMapping.put(EntityType.organization, MainEntityType.organization);
        entityMapping.put(EntityType.project, MainEntityType.project);
        entityMapping.put(EntityType.person, MainEntityType.person);
        entityTypes = Maps.newHashMap();
        entityTypes.put(EntityType.datasource, Datasource.class);
        entityTypes.put(EntityType.organization, Organization.class);
        entityTypes.put(EntityType.project, Project.class);
        entityTypes.put(EntityType.dataset, Dataset.class);
        entityTypes.put(EntityType.otherresearchproduct, OtherResearchProduct.class);
        entityTypes.put(EntityType.software, Software.class);
        entityTypes.put(EntityType.publication, Publication.class);
        entityTypes.put(EntityType.person, Person.class);
        oafTypes = Maps.newHashMap();
        oafTypes.put("datasource", Datasource.class);
        oafTypes.put("organization", Organization.class);
        oafTypes.put("project", Project.class);
        oafTypes.put("dataset", Dataset.class);
        oafTypes.put("otherresearchproduct", OtherResearchProduct.class);
        oafTypes.put("software", Software.class);
        oafTypes.put("publication", Publication.class);
        oafTypes.put("relation", Relation.class);
        oafTypes.put("person", Person.class);
        idPrefixMap = Maps.newHashMap();
        idPrefixMap.put(Datasource.class, "10");
        idPrefixMap.put(Organization.class, "20");
        idPrefixMap.put(Project.class, "40");
        idPrefixMap.put(Dataset.class, "50");
        idPrefixMap.put(OtherResearchProduct.class, "50");
        idPrefixMap.put(Software.class, "50");
        idPrefixMap.put(Publication.class, "50");
        idPrefixMap.put(Person.class, "30");
        entityIdPrefix = Maps.newHashMap();
        entityIdPrefix.put("datasource", "10");
        entityIdPrefix.put("organization", "20");
        entityIdPrefix.put("project", "40");
        entityIdPrefix.put("result", "50");
        entityIdPrefix.put("person", "30");
        idPrefixEntity = Maps.newHashMap();
        idPrefixEntity.put("10", "datasource");
        idPrefixEntity.put("20", "organization");
        idPrefixEntity.put("30", "person");
        idPrefixEntity.put("40", "project");
        idPrefixEntity.put("50", "result");
        relationInverseMap = Maps.newHashMap();
        ModelSupport.set(relationInverseMap, "projectOrganization", "participation", "isParticipant", "hasParticipant");
        ModelSupport.set(relationInverseMap, "resultOrganization", "affiliation", "isAuthorInstitutionOf", "hasAuthorInstitution");
        ModelSupport.set(relationInverseMap, "organizationOrganization", "dedup", "isMergedIn", "merges");
        ModelSupport.set(relationInverseMap, "organizationOrganization", "dedup", "isSimilarTo", "isSimilarTo");
        ModelSupport.set(relationInverseMap, "resultProject", "outcome", "isProducedBy", "produces");
        ModelSupport.set(relationInverseMap, "datasourceOrganization", "provision", "isProvidedBy", "provides");
        ModelSupport.set(relationInverseMap, "resultResult", "similarity", "IsAmongTopNSimilarDocuments", "HasAmongTopNSimilarDocuments");
        ModelSupport.set(relationInverseMap, "resultResult", "supplement", "IsSupplementTo", "IsSupplementedBy");
        ModelSupport.set(relationInverseMap, "resultResult", "part", "IsPartOf", "HasPart");
        ModelSupport.set(relationInverseMap, "resultResult", "dedup", "isMergedIn", "merges");
        ModelSupport.set(relationInverseMap, "resultResult", "dedup", "isSimilarTo", "isSimilarTo");
        ModelSupport.set(relationInverseMap, "resultResult", "citation", "IsCitedBy", "Cites");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsIdenticalTo", "IsIdenticalTo");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsReferencedBy", "References");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsContinuedBy", "Continues");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsDocumentedBy", "Documents");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsDerivedFrom", "IsSourceOf");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsRelatedTo", "IsRelatedTo");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsCompiledBy", "Compiles");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsDescribedBy", "Describes");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsMetadataFor", "IsMetadataOf");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "HasAssociationWith", "HasAssociationWith");
        ModelSupport.set(relationInverseMap, "resultResult", "relationship", "IsRequiredBy", "Requires");
        ModelSupport.set(relationInverseMap, "resultResult", "version", "IsPreviousVersionOf", "IsNewVersionOf");
        ModelSupport.set(relationInverseMap, "resultResult", "version", "IsVariantFormOf", "IsOriginalFormOf");
        ModelSupport.set(relationInverseMap, "resultResult", "version", "IsObsoletedBy", "Obsoletes");
        ModelSupport.set(relationInverseMap, "resultResult", "version", "IsVersionOf", "HasVersion");
        ModelSupport.set(relationInverseMap, "resultResult", "review", "IsReviewedBy", "Reviews");
    }
}

