/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.mdstore;

import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="mdstore_current_versions")
public class MDStoreCurrentVersion
implements Serializable {
    private static final long serialVersionUID = -4757725888593745773L;
    @Id
    @Column(name="mdstore")
    private String mdstore;
    @Column(name="current_version")
    private String currentVersion;

    public String getMdstore() {
        return this.mdstore;
    }

    public void setMdstore(String mdstore) {
        this.mdstore = mdstore;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public static MDStoreCurrentVersion newInstance(String mdId, String versionId) {
        MDStoreCurrentVersion cv = new MDStoreCurrentVersion();
        cv.setMdstore(mdId);
        cv.setCurrentVersion(versionId);
        return cv;
    }

    public static MDStoreCurrentVersion newInstance(MDStoreVersion v) {
        return MDStoreCurrentVersion.newInstance(v.getMdstore(), v.getId());
    }

    public String toString() {
        return String.format("MDStoreCurrentVersion [mdstore=%s, currentVersion=%s]", this.mdstore, this.currentVersion);
    }

    public int hashCode() {
        return Objects.hash(this.currentVersion, this.mdstore);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MDStoreCurrentVersion)) {
            return false;
        }
        MDStoreCurrentVersion other = (MDStoreCurrentVersion)obj;
        return Objects.equals(this.currentVersion, other.currentVersion) && Objects.equals(this.mdstore, other.mdstore);
    }
}

