/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.scholix;

import com.google.common.collect.Iterators;
import java.text.Normalizer;
import java.util.List;
import java.util.stream.Stream;
import me.xuender.unidecode.Unidecode;

public class ScholixComparator {
    public static String normalizeIdnetifier(String input) {
        if (input == null) {
            return null;
        }
        return Normalizer.normalize(input, Normalizer.Form.NFD).toLowerCase();
    }

    public static String normalizeString(String input) {
        if (input == null) {
            return null;
        }
        return Unidecode.decode((String)input).toLowerCase();
    }

    public static <T extends Comparable<T>> int compareObjects(T left, T right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return left.compareTo(right);
    }

    public static <T extends Comparable<T>> int compareList(List<T> left, List<T> right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        Stream sortedLeft = left.stream().sorted();
        Stream sortedRight = right.stream().sorted();
        boolean equals = Iterators.elementsEqual(sortedLeft.iterator(), sortedRight.iterator());
        return equals ? 0 : -1;
    }
}

