package eu.dnetlib.app.directindex.controllers;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/sword/3.0")
@ConditionalOnProperty(value = "dnet.directindex.sword.enabled", havingValue = "true")
public class SwordApiController {
	// @formatter:off
	/*
	private static final String UNKNOWN_USER = "UNKNOWN";

	@Autowired
	private DirectIndexService service;

	@Autowired
	private SolrIndexClientFactory solrIndexClientFactory;

	@Autowired
	private SolrRecordMapper solRecordMapper;

	@Value("${dnet.directindex.baseurl}")
	private String baseUrl;

	@Value("${dnet.directindex.title}")
	private String title;

	@Value("${dnet.directindex.description}")
	private String description;

	@GetMapping("/service-document")
	public SwordServiceDocument getServiceDocument() {
		return SwordServiceDocument.newInstance(baseUrl + "/api/sword/3.0/", title, description);
	}

	@PostMapping("/objects")
	public ResponseEntity<SwordStatusDocument> addObject(
			@RequestHeader("Content-Type") final String contentType,
			@RequestHeader("Content-Disposition") final String contentDisposition,
			@RequestHeader("Digest") final String digest,
			@RequestHeader(value = "In-Progress", defaultValue = "false") final boolean inProgress,
			@RequestHeader(value = "Metadata-Format", defaultValue = "http://purl.org/net/sword/3.0/types/Metadata") final String mdFormat,
			@RequestHeader(value = "Packaging", defaultValue = "http://purl.org/net/sword/3.0/package/Binary") final String packaging,
			@RequestHeader("Slug") final String slug,
			@RequestBody final String json,
			final Authentication authentication) throws SwordException {

		if (StringUtils.isNotBlank(digest)) {
			if (StringUtils.startsWith(digest, "md5=")) {
				if (!DigestUtils.md5Hex(json).equals(StringUtils.substringAfter(digest, "md5="))) { throw new SwordException(SwordErrorType.DigestMismatch); }
			} else if (StringUtils.startsWith(digest, "sha-256=")) {
				if (!DigestUtils.sha256Hex(json).equals(StringUtils.substringAfter(digest, "sha-256="))) {
					throw new SwordException(SwordErrorType.DigestMismatch);
				}
			} else {
				throw new SwordException(SwordErrorType.DigestMismatch);
			}

		}

		if (!MediaType.APPLICATION_JSON_VALUE.equals(contentType)) { throw new SwordException(SwordErrorType.ContentTypeNotAcceptable); }

		if (!"attachment; metadata=true".equals(contentDisposition) || inProgress) { throw new SwordException(SwordErrorType.MethodNotAllowed); }

		if (!"OAF".equals(mdFormat)) { throw new SwordException(SwordErrorType.MetadataFormatNotAcceptable); }

		final HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.setLocation(null);

		try {
			final String openaireId =
					service.prepareMetadataInsertOrUpdate(parseMetadata(json), StringUtils.firstNonBlank(authentication.getName(), UNKNOWN_USER));

			final SwordStatusDocument status = SwordStatusDocument.newInstance(baseUrl + "/api/sword/3.0", openaireId);

			return new ResponseEntity<>(status, responseHeaders, HttpStatus.ACCEPTED);

		} catch (final JsonProcessingException | DirectIndexApiException e) {
			throw new SwordException(SwordErrorType.ContentMalformed);
		}
	}

	@GetMapping("/objects/{id}/metadata")
	public ResponseEntity<ResultEntry> getMetadata(@PathVariable final String id, final Authentication authentication) throws SwordException {

		try {
			final SolrRecord metadata = solrIndexClientFactory.getClient().findRecord(id);

			if (metadata == null) { throw new SwordException(SwordErrorType.NotFound); }

			return new ResponseEntity<>(solRecordMapper.toResultEntry(metadata), HttpStatus.OK);
		} catch (final DirectIndexApiException e) {
			throw new SwordException(SwordErrorType.ContentMalformed);
		}
	}

	@PutMapping("/objects/{id}/metadata")
	public ResponseEntity<Void> replaceMetadata(
			@RequestHeader("Content-Disposition") final String contentDisposition,
			@RequestHeader("Content-Length") final String contentLength,
			@RequestHeader("Content-Type") final String contentType,
			@RequestHeader("Digest") final String digest,
			@RequestHeader(value = "Metadata-Format", defaultValue = "http://purl.org/net/sword/3.0/types/Metadata") final String mdFormat,
			@PathVariable final String id,
			@RequestBody final ResultEntry result,
			final Authentication authentication) throws SwordException {

		try {
			if (!solrIndexClientFactory.getClient().existsRecord(id)) { throw new SwordException(SwordErrorType.NotFound); }

			// The presence of an existing openaire ID is used to force the update
			result.setOpenaireId(id);

			service.prepareMetadataInsertOrUpdate(result, StringUtils.firstNonBlank(authentication.getName(), UNKNOWN_USER));

			return new ResponseEntity<>(HttpStatus.ACCEPTED);
		} catch (final DirectIndexApiException e) {
			throw new SwordException(SwordErrorType.ContentMalformed);
		}
	}

	@DeleteMapping("/objects/{id}")
	public ResponseEntity<Void> deleteObject(@PathVariable final String id, final Authentication authentication) {

		service.prepareMetadataDeletion(id, StringUtils.firstNonBlank(authentication.getName(), UNKNOWN_USER));

		return new ResponseEntity<>(HttpStatus.ACCEPTED);

	}

	private ResultEntry parseMetadata(final String json) throws JsonProcessingException, JsonMappingException {
		return new ObjectMapper().readValue(json, ResultEntry.class);
	}

	@ExceptionHandler(Throwable.class)
	public SwordError handleException(final HttpServletRequest req, final HttpServletResponse res, final Throwable e) throws IOException {

		if (e instanceof SwordException) {
			res.setStatus(((SwordException) e).getError().getHttpCode());
		} else {
			res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		}

		return new SwordError(req, e);
	}
	*/
}
