package eu.dnetlib.app.directindex.repo;

import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "pending_actions")
public class PendingAction {

	@Id
	@Column(name = "id")
	private String id;

	@Column(name = "type")
	private String type;

	@Column(name = "operation")
	@Enumerated(EnumType.STRING)
	private OperationType operation;

	@Column(name = "body")
	private String body;

	@Column(name = "created_by")
	private String createdBy;

	@Column(name = "creation_date")
	private LocalDateTime creationDate;

	@Column(name = "execution_date")
	private LocalDateTime executionDate;

	@Column(name = "error")
	private String error;

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public OperationType getOperation() {
		return operation;
	}

	public void setOperation(final OperationType operation) {
		this.operation = operation;
	}

	public String getBody() {
		return body;
	}

	public void setBody(final String body) {
		this.body = body;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(final String createdBy) {
		this.createdBy = createdBy;
	}

	public LocalDateTime getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final LocalDateTime creationDate) {
		this.creationDate = creationDate;
	}

	public LocalDateTime getExecutionDate() {
		return executionDate;
	}

	public void setExecutionDate(final LocalDateTime executionDate) {
		this.executionDate = executionDate;
	}

	public String getError() {
		return error;
	}

	public void setError(final String error) {
		this.error = error;
	}

}
