package eu.dnetlib.app.directindex.repo;

import java.time.LocalDateTime;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface PendingActionRepository extends JpaRepository<PendingAction, String> {

	@Query(value = "select * from pending_actions where execution_date is null and (upper(operation) = 'INSERT' or upper(operation) = 'UPDATE')", nativeQuery = true)
	List<PendingAction> findInsertOrUpdateOperations();

	@Query(value = "select * from pending_actions where execution_date is null and upper(operation) = 'DELETE'", nativeQuery = true)
	List<PendingAction> findDeleteOperations();

	void deleteByCreationDateBefore(LocalDateTime datatime);

	@Modifying
	@Query(value = "update pending_actions set execution_date = null", nativeQuery = true)
	void resetAllExecutions();

	@Modifying
	@Query(value = "update pending_actions set execution_date = null where "
			+ "creation_date > ? "
			+ "and body::::jsonb->>'collectedFromId'::::text = ?", nativeQuery = true)
	void resetExecutionsForAllTypes(LocalDateTime dt, String dsId);

	@Modifying
	@Query(value = "update pending_actions set execution_date = null where "
			+ "creation_date > ? "
			+ "and body::::jsonb->>'collectedFromId'::::text = ? "
			+ "and type = ?", nativeQuery = true)
	void resetExecutionsForType(LocalDateTime dt, String dsId, String type);

	@Modifying
	@Query(value = "update pending_actions set execution_date = null where id = ?", nativeQuery = true)
	void resetExecutionForId(String id);

	long countByExecutionDateIsNull();

	long countByOperation(OperationType operation);

	long countByOperationAndExecutionDateIsNull(OperationType operation);

	@Query(value = "select min(creation_date) from pending_actions", nativeQuery = true)
	LocalDateTime findMinCreationDate();

	@Query(value = "select max(creation_date) from pending_actions", nativeQuery = true)
	LocalDateTime findMaxCreationDate();

	@Query(value = "select min(execution_date) from pending_actions", nativeQuery = true)
	LocalDateTime findMinExecutionDate();

	@Query(value = "select max(execution_date) from pending_actions", nativeQuery = true)
	LocalDateTime findMaxExecutionDate();

	long countByErrorIsNotNull();

	@Modifying
	@Query(value = "delete from pending_actions where EXTRACT(DAY from now()-creation_date) > ?", nativeQuery = true)
	void deleteObsoleteRecords(int maxNumberOfDays);

}
