/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.controllers;

import eu.dnetlib.app.directindex.controllers.LegacyApiController;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.app.directindex.input.ResultEntry;
import eu.dnetlib.app.directindex.mapping.SolrRecordMapper;
import eu.dnetlib.app.directindex.service.DirectIndexService;
import eu.dnetlib.app.directindex.solr.SolrIndexClientFactory;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/results"})
@ConditionalOnProperty(value={"dnet.directindex.legacy.enabled"}, havingValue="true")
public class LegacyApiController {
    private static final Log log = LogFactory.getLog(LegacyApiController.class);
    @Autowired
    private DirectIndexService service;
    @Autowired
    private SolrRecordMapper solrRecordMapper;
    @Autowired
    private SolrIndexClientFactory solrIndexClientFactory;

    @PostMapping(value={"/feedObject"})
    @Deprecated
    public String feedResult_deprecated(@RequestBody ResultEntry pub, HttpServletRequest req) throws DirectIndexApiException {
        return this.feedResult(pub, req);
    }

    @PostMapping
    public String feedResult(@RequestBody ResultEntry pub, HttpServletRequest req) throws DirectIndexApiException {
        return this.service.prepareMetadataInsertOrUpdate(pub, req.getRemoteAddr());
    }

    @GetMapping(value={"/{openaireId}"})
    public Map<String, Object> getResultWithOpenaireId(@PathVariable(value="openaireId") String openaireId) throws DirectIndexApiException {
        SolrRecord indexed = this.solrIndexClientFactory.getClient().findRecord(openaireId);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        res.put("indexed_oaf", indexed);
        res.put("indexed_simple", indexed != null ? this.solrRecordMapper.toResultEntry(indexed) : null);
        res.put("pending_action", this.service.findPendingAction(openaireId).orElse(null));
        return res;
    }

    @DeleteMapping(value={"/{openaireId}"})
    public boolean deleteResultWithOpenaireId(@PathVariable(value="openaireId") String openaireId, HttpServletRequest req) throws DirectIndexApiException {
        this.service.prepareMetadataDeletion(openaireId, req.getRemoteAddr());
        return true;
    }

    @DeleteMapping
    public boolean deleteResultWithOriginalId(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, HttpServletRequest req) throws DirectIndexApiException {
        String openaireId = this.solrRecordMapper.calculateOpenaireId(originalId, collectedFromId);
        this.service.prepareMetadataDeletion(openaireId, req.getRemoteAddr());
        return true;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error in direct index API", (Throwable)e);
        return new ErrorMessage(this, e);
    }
}

