/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.mapping;

import eu.dnetlib.app.directindex.mapping.InstanceWithTypeCode;
import eu.dnetlib.dhp.schema.solr.BestAccessRight;
import eu.dnetlib.dhp.schema.solr.Instance;
import eu.dnetlib.dhp.schema.solr.Language;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLSolrSerializer {
    private static final Namespace DRI_NS = new Namespace("dri", "http://www.driver-repository.eu/namespace/dri");
    private static final Namespace OAF_NS = new Namespace("oaf", "http://namespace.openaire.eu/oaf");
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

    public static String generateXML(SolrRecord sr) {
        Element result = DocumentHelper.createElement((String)"result");
        XMLSolrSerializer.populateHeader((SolrRecord)sr, (Element)result.addElement("header"));
        XMLSolrSerializer.poulateMetadata((SolrRecord)sr, (Element)result.addElement("metadata"));
        return result.asXML();
    }

    private static void populateHeader(SolrRecord sr, Element header) {
        header.addElement(new QName("objIdentifier", DRI_NS)).addText(sr.getHeader().getId());
        header.addElement(new QName("dateOfCollection", DRI_NS)).addText("");
        header.addElement(new QName("dateOfTransformation", DRI_NS)).addText("");
        header.addElement(new QName("status", DRI_NS)).addText(sr.getHeader().getStatus().name());
    }

    private static void poulateMetadata(SolrRecord sr, Element metadata) {
        Element entity = metadata.addElement(new QName("entity", OAF_NS));
        entity.addAttribute(new QName("schemaLocation", XSI_NS), "http://namespace.openaire.eu/oaf https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        if (sr.getResult() != null) {
            XMLSolrSerializer.populateResultFields((SolrRecord)sr, (Element)entity.addElement(new QName("result", OAF_NS)));
        }
    }

    private static void populateResultFields(SolrRecord sr, Element fields) {
        if (sr.getHeader().getOriginalId() != null) {
            sr.getHeader().getOriginalId().forEach(id -> fields.addElement("originalId").addText(id));
        }
        XMLSolrSerializer.addStructuredField((Element)fields, (String)"title", (String)"main title", (String)"dnet:dataCite_title", (String)sr.getResult().getMaintitle());
        if (sr.getResult().getBestaccessright() != null) {
            BestAccessRight r = sr.getResult().getBestaccessright();
            XMLSolrSerializer.addStructuredField((Element)fields, (String)"bestaccessright", (String)r.getCode(), (String)r.getLabel(), (String)"dnet:access_modes", null);
        }
        if (sr.getResult().getAuthor() != null) {
            sr.getResult().getAuthor().forEach(a -> {
                Element creator = fields.addElement("creator");
                creator.addAttribute("rank", "" + a.getRank());
                creator.addText(a.getFullname());
            });
        }
        if (sr.getResult().getDescription() != null) {
            sr.getResult().getDescription().forEach(s -> fields.addElement("description").addText(s));
        }
        if (sr.getResult().getLanguage() != null) {
            Language l = sr.getResult().getLanguage();
            XMLSolrSerializer.addStructuredField((Element)fields, (String)"language", (String)l.getCode(), (String)l.getLabel(), (String)"dnet:languages", null);
        }
        if (sr.getResult().getResulttype() != null) {
            XMLSolrSerializer.addStructuredField((Element)fields, (String)"resulttype", (String)sr.getResult().getResulttype(), (String)"dnet:result_typologies", null);
        }
        if (sr.getContext() != null) {
            sr.getContext().forEach(ctx -> {
                Element ctxNode = fields.addElement("context");
                ctxNode.addAttribute("id", ctx.getId());
                ctxNode.addAttribute("label", ctx.getLabel());
                ctxNode.addAttribute("type", ctx.getType());
                if (ctx.getCategory() != null) {
                    ctx.getCategory().forEach(cat -> {
                        Element catNode = ctxNode.addElement("category");
                        catNode.addAttribute("id", cat.getId());
                        catNode.addAttribute("label", cat.getLabel());
                        if (cat.getConcept() != null) {
                            cat.getConcept().forEach(cpt -> {
                                Element cptNode = catNode.addElement("concept");
                                cptNode.addAttribute("id", cpt.getId());
                                cptNode.addAttribute("label", cpt.getLabel());
                            });
                        }
                    });
                }
            });
        }
        if (sr.getResult().getEmbargoenddate() != null) {
            fields.addElement("embargoenddate").addText(sr.getResult().getEmbargoenddate());
        }
        if (sr.getCollectedfrom() != null) {
            sr.getCollectedfrom().forEach(p -> {
                Element collectedFrom = fields.addElement("collectedfrom");
                collectedFrom.addAttribute("id", p.getDsId());
                collectedFrom.addAttribute("name", p.getDsName());
            });
        }
        Element datainfo = fields.addElement("datainfo");
        datainfo.addElement("inferred").addText("false");
        datainfo.addElement("deletedbyinference").addText("false");
        datainfo.addElement("trust").addText("0.9");
        datainfo.addElement("inferenceprovenance").addText("");
        XMLSolrSerializer.addStructuredField((Element)datainfo, (String)"provenanceaction", (String)"user:insert", (String)"dnet:provenanceActions", null);
        Element relsNode = fields.addElement("rels");
        if (sr.getLinks() != null) {
            sr.getLinks().forEach(p -> XMLSolrSerializer.addRelProject((Element)relsNode, (RelatedRecord)p));
        }
        Element childrenNode = fields.addElement("children");
        if (sr.getResult().getInstance() != null) {
            sr.getResult().getInstance().forEach(p -> XMLSolrSerializer.addResultInstance((Element)childrenNode, (Instance)p));
        }
    }

    private static void addResultInstance(Element childrenNode, Instance i) {
        Element instanceNode = childrenNode.addElement("instance");
        if (i instanceof InstanceWithTypeCode) {
            XMLSolrSerializer.addStructuredField((Element)instanceNode, (String)"instancetype", (String)((InstanceWithTypeCode)i).getInstancetypeCode(), (String)i.getInstancetype(), (String)"dnet:publication_resource", null);
        }
        XMLSolrSerializer.addStructuredField((Element)instanceNode, (String)"accessright", (String)i.getAccessright().getCode(), (String)i.getAccessright().getLabel(), (String)"dnet:access_modes", null);
        Element collectedFrom = instanceNode.addElement("collectedfrom");
        collectedFrom.addAttribute("id", i.getCollectedfrom().getDsId());
        collectedFrom.addAttribute("name", i.getCollectedfrom().getDsName());
        Element hostedBy = instanceNode.addElement("hostedby");
        hostedBy.addAttribute("id", i.getHostedby().getDsId());
        hostedBy.addAttribute("name", i.getHostedby().getDsName());
        if (i.getUrl() != null) {
            i.getUrl().forEach(url -> instanceNode.addElement("webresource").addElement("url").addText(url));
        }
    }

    private static void addRelProject(Element relsNode, RelatedRecord p) {
        if (p.getHeader().getRelatedRecordType() != RecordType.project) {
            return;
        }
        Element rel = relsNode.addElement("rel");
        rel.addAttribute("inferred", "false");
        rel.addAttribute("trust", "0.9");
        rel.addAttribute("inferenceprovenance", "");
        rel.addAttribute("provenanceaction", "user:claim");
        Element to = rel.addElement("to");
        to.addAttribute("class", "isProducedBy");
        to.addAttribute("scheme", "dnet:result_project_relations");
        to.addAttribute("type", RecordType.project.name());
        to.addText(p.getHeader().getRelatedIdentifier());
        rel.addElement("code").addText(p.getCode());
        rel.addElement("acronym").addText(p.getAcronym());
        rel.addElement("title").addText(p.getProjectTitle());
        if (p.getFunding() != null) {
            Element funding = rel.addElement("funding");
            if (p.getFunding().getFunder() != null) {
                Element funder = funding.addElement("funder");
                funder.addAttribute("id", p.getFunding().getFunder().getId());
                funder.addAttribute("name", p.getFunding().getFunder().getName());
                funder.addAttribute("shortname", p.getFunding().getFunder().getShortname());
                if (p.getFunding().getFunder().getJurisdiction() != null) {
                    funder.addAttribute("jurisdiction", p.getFunding().getFunder().getJurisdiction().getCode());
                }
            }
            if (p.getFunding().getLevel0() != null) {
                Element level0 = funding.addElement("funding_level_0");
                level0.addAttribute("name", p.getFunding().getLevel0().getName());
                level0.addText(p.getFunding().getLevel0().getId());
            }
        }
    }

    private static void addStructuredField(Element parent, String fieldName, String classid, String scheme, String value) {
        XMLSolrSerializer.addStructuredField((Element)parent, (String)fieldName, (String)classid, (String)classid, (String)scheme, (String)value);
    }

    private static void addStructuredField(Element parent, String fieldName, String classid, String classname, String scheme, String value) {
        Element elem = parent.addElement(fieldName);
        elem.addAttribute("classid", classid);
        elem.addAttribute("classname", classname);
        elem.addAttribute("schemeid", scheme);
        elem.addAttribute("schemename", scheme);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            elem.addText(value);
        }
    }
}

