/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.solr;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrIndexClient {
    private final SolrClient solrClient;

    public SolrIndexClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public void commit() throws DirectIndexApiException {
        try {
            this.solrClient.commit();
        }
        catch (Throwable e) {
            throw new DirectIndexApiException("Error performing commit", e);
        }
    }

    public UpdateResponse addRecords(Iterator<SolrInputDocument> iter) throws DirectIndexApiException {
        try {
            return this.solrClient.add(iter);
        }
        catch (Throwable e) {
            throw new DirectIndexApiException("Error creating solr document", e);
        }
    }

    public UpdateResponse addRecords(SolrInputDocument ... records) throws Exception {
        return this.addRecords(Arrays.stream(records).iterator());
    }

    public UpdateResponse deleteRecord(String id) throws DirectIndexApiException {
        try {
            String query = String.format("objidentifier:\"%s\" OR resultdupid:\"%s\"", id, id);
            return this.solrClient.deleteByQuery(query);
        }
        catch (IOException | SolrServerException e) {
            throw new DirectIndexApiException(e);
        }
    }

    public SolrRecord findRecord(String id) throws DirectIndexApiException {
        try {
            QueryResponse response = this.solrClient.query(this.queryParamsForId(id));
            SolrDocumentList documents = response.getResults();
            if (documents.isEmpty()) {
                return null;
            }
            String json = (String)((SolrDocument)documents.get(0)).getFirstValue("__json");
            return (SolrRecord)new ObjectMapper().readValue(json, SolrRecord.class);
        }
        catch (IOException | SolrServerException e) {
            throw new DirectIndexApiException("Error executing solr query", e);
        }
    }

    public boolean existsRecord(String id) throws DirectIndexApiException {
        try {
            QueryResponse response = this.solrClient.query(this.queryParamsForId(id));
            SolrDocumentList documents = response.getResults();
            return !documents.isEmpty();
        }
        catch (IOException | SolrServerException e) {
            throw new DirectIndexApiException("Error executing solr query", e);
        }
    }

    private SolrParams queryParamsForId(String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("q", "objidentifier:" + ClientUtils.escapeQueryChars((String)id));
        params.put("fl", "__json");
        return new MapSolrParams(params);
    }
}

