/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.context;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.exporter.model.context.Category;
import eu.dnetlib.openaire.exporter.model.context.Concept;
import eu.dnetlib.openaire.exporter.model.context.Context;
import eu.dnetlib.openaire.exporter.model.context.Param;
import eu.dnetlib.openaire.exporter.model.funders.FunderDetails;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * Exception performing whole class analysis ignored.
 */
@Deprecated
public class ContextMappingUtils {
    private static final List<String> DATE_PATTERN = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm:ssXXX", "yyyy-MM-dd'T'hh:mm:ss+00:00"});
    private static final Log log = LogFactory.getLog(ContextMappingUtils.class);

    public static Context parseContext(String s, Queue<Throwable> errors) {
        try {
            Document doc = DocumentHelper.parseText((String)s);
            Element eContext = (Element)doc.selectSingleNode("/RESOURCE_PROFILE/BODY/CONFIGURATION/context");
            String creationDate = eContext.valueOf("./param[./@name='creationdate']/text()");
            String otherDate = doc.valueOf("/RESOURCE_PROFILE/HEADER/DATE_OF_CREATION/@value");
            Context c = new Context().setId(eContext.attributeValue("id")).setLabel(eContext.attributeValue("label")).setType(eContext.attributeValue("type")).setLastUpdateDate(ContextMappingUtils.asDate((String)otherDate)).setParams(ContextMappingUtils.parseParams((Element)eContext)).setCategories(ContextMappingUtils.parseCategories((Element)eContext));
            if (StringUtils.isNotBlank((CharSequence)creationDate)) {
                c.setCreationDate(ContextMappingUtils.asDate((String)creationDate));
            } else {
                c.setCreationDate(ContextMappingUtils.asDate((String)otherDate));
            }
            return c;
        }
        catch (DocumentException e) {
            errors.add(e);
            return new Context();
        }
    }

    private static Date asDate(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        for (String pattern : DATE_PATTERN) {
            try {
                Date res = DateUtils.parseDate((String)s, (String[])new String[]{pattern});
                if (res == null) continue;
                return res;
            }
            catch (ParseException parseException) {
            }
        }
        log.warn((Object)("Invalid Date: " + s));
        return null;
    }

    private static Map<String, Category> parseCategories(Element eContext) {
        List eCategory = eContext.selectNodes("//category");
        return eCategory.stream().map(n -> (Element)n).map(eCat -> new Category().setClaim(ContextMappingUtils.getClaim((Element)eCat).booleanValue()).setId(eCat.attributeValue("id")).setLabel(eCat.attributeValue("label")).setParams(ContextMappingUtils.parseParams((Element)eCat)).setConcepts(ContextMappingUtils.parseConcepts((Element)eCat))).collect(Collectors.toMap(Category::getId, Functions.identity()));
    }

    private static List<Concept> parseConcepts(Element eCategory) {
        List eConcepts = eCategory.selectNodes("./concept");
        return eConcepts.stream().map(n -> (Element)n).map(eCon -> new Concept().setClaim(ContextMappingUtils.getClaim((Element)eCon).booleanValue()).setId(eCon.attributeValue("id")).setLabel(eCon.attributeValue("label")).setParams(ContextMappingUtils.parseParams((Element)eCon)).setConcepts(ContextMappingUtils.parseConcepts((Element)eCon))).collect(Collectors.toList());
    }

    private static Boolean getClaim(Element eCon) {
        String claim = eCon.attributeValue("claim");
        return BooleanUtils.toBooleanObject((String)(StringUtils.isNotBlank((CharSequence)claim) ? claim : "false"));
    }

    private static List<Param> parseParams(Element e) {
        List params = e.selectNodes("./param");
        return params.stream().map(n -> (Element)n).map(p -> new Param().setName(p.attributeValue("name")).setValue(p.getTextTrim())).collect(Collectors.toList());
    }

    public static FunderDetails asFunderDetails(Context c) {
        return new FunderDetails().setId(c.getId()).setName(c.getLabel()).setShortname(c.getId());
    }
}

