/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.common;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.dsm.Response;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractExporterController {
    private static final Log log = LogFactory.getLog(AbstractExporterController.class);

    @ResponseBody
    @ExceptionHandler(value={DsmApiException.class, CommunityException.class, Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessage handle500(Exception e) {
        return this._handleError(e);
    }

    @ResponseBody
    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorMessage handle404(Exception e) {
        return this._handleError(e);
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public List<ErrorMessage> handle400(MethodArgumentNotValidException e) {
        return e.getBindingResult().getFieldErrors().stream().map(fe -> new ErrorMessage(this, String.format("field '%s'", fe.getField()), String.format("rejected value '%s'", fe.getRejectedValue()), fe.getDefaultMessage())).collect(Collectors.toList());
    }

    private ErrorMessage _handleError(Exception e) {
        log.error((Object)e);
        if (StringUtils.containsIgnoreCase((CharSequence)ExceptionUtils.getRootCauseMessage((Throwable)e), (CharSequence)"Broken pipe")) {
            return null;
        }
        return new ErrorMessage(this, e);
    }

    protected <T extends Response> T prepareResponse(int page, int size, StopWatch stopWatch, T rsp) {
        rsp.getHeader().setTime(stopWatch.getTime()).setPage(page).setSize(size);
        return rsp;
    }
}

