/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community.importer;

import com.google.common.collect.Sets;
import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.importer.CommunityImporterService;
import eu.dnetlib.openaire.community.model.DbOrganization;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.model.context.Context;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community.import"}, havingValue="true")
@Tag(name="OpenAIRE Communities: Migration API", description="OpenAIRE Communities: Migration API")
public class CommunityImporterController
extends AbstractDnetController {
    public static final Set<String> communityBlackList = Sets.newHashSet();
    @Autowired
    private CommunityImporterService importer;
    @Autowired
    private ISClient isClient;
    private static final Log log = LogFactory.getLog(CommunityImporterController.class);

    @GetMapping(value={"/community_importer/communities"})
    public List<String> importProfiles() throws CommunityException {
        try {
            Map contextMap = this.getContextMap();
            List<String> list = contextMap.keySet().stream().filter(id -> !communityBlackList.contains(id)).collect(Collectors.toList());
            list.forEach(id -> this.importer.importCommunity((Context)contextMap.get(id)));
            return list;
        }
        catch (Throwable e) {
            log.error((Object)"Error importing communities", e);
            throw new CommunityException(e.getMessage());
        }
    }

    @GetMapping(value={"/community_importer/propagationOrgs"})
    public List<DbOrganization> importPropagationOrgs(@RequestParam String profileId, @RequestParam(required=false, defaultValue="false") boolean simulation) throws Exception {
        try {
            String xml = this.isClient.getProfile(profileId);
            return this.importer.importPropagationOrganizationsFromProfile(xml, simulation);
        }
        catch (Throwable e) {
            log.error((Object)"Error importing communities", e);
            throw new CommunityException(e.getMessage());
        }
    }

    private Map<String, Context> getContextMap() throws CommunityException {
        try {
            return this.isClient.getCommunityContextMap();
        }
        catch (IOException e) {
            throw new CommunityException((Throwable)e);
        }
    }
}

