/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import eu.dnetlib.openaire.exporter.model.context.Param;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
public class SubCommunity {
    @Schema(description="the id of the subCommunity", required=true)
    private String subCommunityId;
    @Schema(description="the community identifier this sub community belongs to", required=true)
    private String communityId;
    @Schema(description="the parent of the subCommunity, if available (it should the id of another subCommunity)", required=false)
    private String parent;
    @Schema(description="the label of the subCommunity", required=true)
    private String label;
    @Schema(description="the category of the subCommunity", required=true)
    private String category;
    @Schema(description="the parameters of the subCommunity", required=true)
    private List<Param> params = new ArrayList<Param>();
    @Schema(description="it supports the claims", required=true)
    private boolean claim = false;
    @Schema(description="it is browsable", required=true)
    private boolean browsable = false;
    @Schema(description="list of subjects (keywords) that characterise this sub-community")
    private List<String> subjects;
    @Schema(description="list of fos that characterise this sub-community")
    private List<String> fos;
    @Schema(description="list of sdg that characterise this sub-community")
    private List<String> sdg;
    @Schema(description="list of advanced criteria to associate results to this sub-community")
    private SelectionCriteria advancedConstraints;
    @Schema(description="list of the remove criteria for this sub-community")
    private SelectionCriteria removeConstraints;
    @Schema(description="Zenodo community associated to this sub-community")
    protected String zenodoCommunity;
    @Schema(description="other zenodo communities for this sub-community")
    private List<String> otherZenodoCommunities;
    @Schema(description="Suggested Acknowledgements for this sub-community")
    private List<String> suggestedAcknowledgements;

    public String getSubCommunityId() {
        return this.subCommunityId;
    }

    public void setSubCommunityId(String subCommunityId) {
        this.subCommunityId = subCommunityId;
    }

    public String getCommunityId() {
        return this.communityId;
    }

    public void setCommunityId(String communityId) {
        this.communityId = communityId;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> map) {
        this.params = map;
    }

    public boolean isClaim() {
        return this.claim;
    }

    public void setClaim(boolean claim) {
        this.claim = claim;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public void setBrowsable(boolean browsable) {
        this.browsable = browsable;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public List<String> getFos() {
        return this.fos;
    }

    public void setFos(List<String> fos) {
        this.fos = fos;
    }

    public List<String> getSdg() {
        return this.sdg;
    }

    public void setSdg(List<String> sdg) {
        this.sdg = sdg;
    }

    public SelectionCriteria getAdvancedConstraints() {
        return this.advancedConstraints;
    }

    public void setAdvancedConstraints(SelectionCriteria advancedConstraints) {
        this.advancedConstraints = advancedConstraints;
    }

    public SelectionCriteria getRemoveConstraints() {
        return this.removeConstraints;
    }

    public void setRemoveConstraints(SelectionCriteria removeConstraints) {
        this.removeConstraints = removeConstraints;
    }

    public String getZenodoCommunity() {
        return this.zenodoCommunity;
    }

    public void setZenodoCommunity(String zenodoCommunity) {
        this.zenodoCommunity = zenodoCommunity;
    }

    public List<String> getOtherZenodoCommunities() {
        return this.otherZenodoCommunities;
    }

    public void setOtherZenodoCommunities(List<String> otherZenodoCommunities) {
        this.otherZenodoCommunities = otherZenodoCommunities;
    }

    public List<String> getSuggestedAcknowledgements() {
        return this.suggestedAcknowledgements;
    }

    public void setSuggestedAcknowledgements(List<String> suggestedAcknowledgements) {
        this.suggestedAcknowledgements = suggestedAcknowledgements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SubCommunity [subCommunityId=");
        builder.append(this.subCommunityId);
        builder.append(", communityId=");
        builder.append(this.communityId);
        builder.append(", parent=");
        builder.append(this.parent);
        builder.append(", label=");
        builder.append(this.label);
        builder.append(", category=");
        builder.append(this.category);
        builder.append(", params=");
        builder.append(this.params);
        builder.append(", claim=");
        builder.append(this.claim);
        builder.append(", browsable=");
        builder.append(this.browsable);
        builder.append(", subjects=");
        builder.append(this.subjects);
        builder.append(", fos=");
        builder.append(this.fos);
        builder.append(", sdg=");
        builder.append(this.sdg);
        builder.append(", advancedConstraints=");
        builder.append(this.advancedConstraints);
        builder.append(", removeConstraints=");
        builder.append(this.removeConstraints);
        builder.append(", zenodoCommunity=");
        builder.append(this.zenodoCommunity);
        builder.append(", otherZenodoCommunities=");
        builder.append(this.otherZenodoCommunities);
        builder.append(", suggestedAcknowledgements=");
        builder.append(this.suggestedAcknowledgements);
        builder.append("]");
        return builder.toString();
    }
}

