/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.model.utils;

import eu.dnetlib.organizations.model.OrganizationSearchEntry;
import eu.dnetlib.organizations.model.utils.OrganizationSearchEntrySpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.domain.Specification;

public class OrganizationSearchEntrySpecification
implements Specification<OrganizationSearchEntry> {
    private static final long serialVersionUID = 1832753188603502182L;
    private final List<Pair<SearchableField, String>> containsConds = new ArrayList();
    private final List<Pair<SearchableField, String>> notContainsConds = new ArrayList();
    private final List<Pair<SearchableField, String>> equalsConds = new ArrayList();
    private final List<Pair<SearchableField, String>> notEqualsConds = new ArrayList();

    public void addTermConditions(SearchableField field, String[] terms) {
        if (terms == null) {
            return;
        }
        block6: for (String t : terms) {
            if (!StringUtils.isNotBlank((CharSequence)t)) continue;
            char op = t.charAt(0);
            String val = t.substring(1).trim();
            switch (op) {
                case '~': {
                    this.containsConds.add(Pair.of((Object)field, (Object)val));
                    continue block6;
                }
                case '-': {
                    this.notContainsConds.add(Pair.of((Object)field, (Object)val));
                    continue block6;
                }
                case ':': {
                    this.equalsConds.add(Pair.of((Object)field, (Object)val));
                    continue block6;
                }
                case '!': {
                    this.notEqualsConds.add(Pair.of((Object)field, (Object)val));
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Invalid search operator: " + op);
                }
            }
        }
    }

    public Predicate toPredicate(Root<OrganizationSearchEntry> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Predicate fieldsPredicate = criteriaBuilder.conjunction();
        List expressions = fieldsPredicate.getExpressions();
        this.containsConds.stream().map(pair -> this.createContainsExpr(root, criteriaBuilder, (SearchableField)pair.getKey(), (String)pair.getValue())).filter(Objects::nonNull).forEach(expressions::add);
        this.notContainsConds.stream().map(pair -> this.createContainsExpr(root, criteriaBuilder, (SearchableField)pair.getKey(), (String)pair.getValue())).filter(Objects::nonNull).map(arg_0 -> ((CriteriaBuilder)criteriaBuilder).not(arg_0)).forEach(expressions::add);
        this.equalsConds.stream().map(pair -> this.createEqualsExpr(root, criteriaBuilder, (SearchableField)pair.getKey(), (String)pair.getValue())).filter(Objects::nonNull).forEach(expressions::add);
        this.notEqualsConds.stream().map(pair -> this.createEqualsExpr(root, criteriaBuilder, (SearchableField)pair.getKey(), (String)pair.getValue())).filter(Objects::nonNull).map(arg_0 -> ((CriteriaBuilder)criteriaBuilder).not(arg_0)).forEach(expressions::add);
        return fieldsPredicate;
    }

    private Expression<Boolean> createContainsExpr(Root<OrganizationSearchEntry> root, CriteriaBuilder cb, SearchableField field, String value) {
        String likeVal = "%" + value.toLowerCase().replaceAll(" ", "%") + "%";
        switch (1.$SwitchMap$eu$dnetlib$organizations$model$utils$OrganizationSearchEntrySpecification$SearchableField[field.ordinal()]) {
            case 1: {
                return cb.isTrue(cb.function("fulltext_search", Boolean.class, new Expression[]{root.get("fullTextVector"), cb.literal((Object)value)}));
            }
            case 2: {
                return cb.like((Expression)root.get("nameNormalized"), likeVal);
            }
            case 3: {
                return cb.like((Expression)root.get("cityNormalized"), likeVal);
            }
            case 4: {
                return cb.like((Expression)root.get("otherNamesNormalized"), likeVal);
            }
        }
        throw new RuntimeException("The contains/notContains predicates are not available for field: " + field);
    }

    private Expression<Boolean> createEqualsExpr(Root<OrganizationSearchEntry> root, CriteriaBuilder cb, SearchableField field, String value) {
        switch (1.$SwitchMap$eu$dnetlib$organizations$model$utils$OrganizationSearchEntrySpecification$SearchableField[field.ordinal()]) {
            case 5: {
                return cb.equal((Expression)root.get("id"), (Object)value);
            }
            case 6: {
                return cb.equal((Expression)root.get("openaireId"), (Object)value);
            }
            case 2: {
                return cb.equal(cb.lower((Expression)root.get("nameNormalized")), (Object)value.toLowerCase());
            }
            case 4: {
                return cb.like((Expression)root.get("otherNamesNormalized"), "%\u00a7" + value.toLowerCase() + "\u00a7%");
            }
            case 7: {
                return cb.like((Expression)root.get("acronymsNormalized"), "%\u00a7" + value.toLowerCase() + "\u00a7%");
            }
            case 8: {
                return cb.equal((Expression)root.get("typeNormalized"), (Object)value.toLowerCase());
            }
            case 3: {
                return cb.equal((Expression)root.get("cityNormalized"), (Object)value.toLowerCase());
            }
            case 9: {
                return cb.equal((Expression)root.get("countryNormalized"), (Object)value.toLowerCase());
            }
            case 10: {
                return cb.equal((Expression)root.get("statusNormalized"), (Object)value.toLowerCase());
            }
            case 11: {
                return cb.like((Expression)root.get("pidsNormalized"), "%\u00a7" + value.toLowerCase() + "\u00a7%");
            }
        }
        throw new RuntimeException("The 'equals' predicate is not available for field: " + field);
    }
}

