/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils;

import eu.dnetlib.dhp.utils.FunctionalInterfaceSupport;
import java.util.Objects;
import java.util.function.Function;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkSessionSupport {
    private SparkSessionSupport() {
    }

    public static void runWithSparkSession(SparkConf conf, Boolean isSparkSessionManaged, FunctionalInterfaceSupport.ThrowingConsumer<SparkSession, Exception> fn) {
        SparkSessionSupport.runWithSparkSession(c -> SparkSession.builder().config(c).getOrCreate(), conf, isSparkSessionManaged, fn);
    }

    public static void runWithSparkHiveSession(SparkConf conf, Boolean isSparkSessionManaged, FunctionalInterfaceSupport.ThrowingConsumer<SparkSession, Exception> fn) {
        SparkSessionSupport.runWithSparkSession(c -> SparkSession.builder().config(c).enableHiveSupport().getOrCreate(), conf, isSparkSessionManaged, fn);
    }

    public static void runWithSparkSession(Function<SparkConf, SparkSession> sparkSessionBuilder, SparkConf conf, Boolean isSparkSessionManaged, FunctionalInterfaceSupport.ThrowingConsumer<SparkSession, Exception> fn) {
        SparkSession spark = null;
        try {
            spark = sparkSessionBuilder.apply(conf);
            fn.accept(spark);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(spark) && isSparkSessionManaged.booleanValue()) {
                spark.stop();
            }
        }
    }
}

