/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.index;

import eu.dnetlib.scholexplorer.api.ScholixException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class Pool<T>
implements Cloneable {
    protected GenericObjectPool<T> internalPool;

    public Pool() {
    }

    public Pool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        this.initPool(poolConfig, factory);
    }

    public void initPool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    protected void closeInternalPool() throws ScholixException {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new ScholixException("Could not destroy the pool", (Throwable)e);
        }
    }

    public T getResource() throws ScholixException {
        try {
            return (T)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new ScholixException("Could not get a resource from the pool", (Throwable)e);
        }
    }

    public void returnResource(T resource) throws ScholixException {
        if (resource != null) {
            this.returnResourceObject(resource);
        }
    }

    private void returnResourceObject(T resource) throws ScholixException {
        if (resource == null) {
            return;
        }
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new ScholixException("Could not return the resource to the pool", (Throwable)e);
        }
    }

    public void returnBrokenResource(T resource) throws ScholixException {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    private void returnBrokenResourceObject(T resource) throws ScholixException {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new ScholixException("Could not return the resource to the pool", (Throwable)e);
        }
    }

    public void destroy() throws ScholixException {
        this.closeInternalPool();
    }

    public int getNumActive() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumActive();
    }

    public int getNumIdle() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumIdle();
    }

    public int getNumWaiters() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumWaiters();
    }

    public long getMeanBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMeanBorrowWaitTimeMillis();
    }

    public long getMaxBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMaxBorrowWaitTimeMillis();
    }

    private boolean poolInactive() {
        return this.internalPool == null || this.internalPool.isClosed();
    }

    public void addObjects(int count) throws Exception {
        try {
            for (int i = 0; i < count; ++i) {
                this.internalPool.addObject();
            }
        }
        catch (Exception e) {
            throw new Exception("Error trying to add idle objects", e);
        }
    }
}

