/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.model;

import eu.dnetlib.scholexplorer.api.model.KPIRelMetric;
import eu.dnetlib.scholexplorer.api.model.KPISummaryMetric;
import java.util.List;

public class KPIModel {
    private Long scholix;
    private Long entities;
    private List<KPIRelMetric> relations;
    private List<KPISummaryMetric> summaries;

    public KPIModel() {
    }

    public KPIModel(Long scholix, Long entities, List<KPIRelMetric> relations, List<KPISummaryMetric> summaries) {
        this.scholix = scholix;
        this.entities = entities;
        this.relations = relations;
        this.summaries = summaries;
    }

    public Long getScholix() {
        return this.scholix;
    }

    public void setScholix(Long scholix) {
        this.scholix = scholix;
    }

    public Long getEntities() {
        return this.entities;
    }

    public void setEntities(Long entities) {
        this.entities = entities;
    }

    public List<KPIRelMetric> getRelations() {
        return this.relations;
    }

    public void setRelations(List<KPIRelMetric> relations) {
        this.relations = relations;
    }

    public List<KPISummaryMetric> getSummaries() {
        return this.summaries;
    }

    public void setSummaries(List<KPISummaryMetric> summaries) {
        this.summaries = summaries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("# HELP scholexplorer_scholix Total number of relationships \n");
        sb.append("scholexplorer_scholix ");
        sb.append(this.scholix.toString());
        sb.append("\n");
        sb.append("# HELP scholexplorer_entities Total number of entities \n");
        sb.append("scholexplorer_entities ");
        sb.append(this.entities.toString());
        sb.append("\n");
        this.summaries.forEach(sm -> sb.append(String.format("# HELP %s Summary of this type of entity\n%s %d\n", sm.getType(), sm.getType(), sm.getCount())));
        sb.append("# HELP scholexplorer_scholix_relations Total number of relationships between source and target type \n");
        this.relations.forEach(r -> sb.append(String.format("scholexplorer_scholix_relations{source=\"%s\", target=\"%s\"} %d\n", r.getSourceType(), r.getTargetType(), r.getCount())));
        return sb.toString();
    }
}

