/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetexploremetrics.service;

import eu.dnetlib.dnetexploremetrics.dao.MetricsDAO;
import eu.dnetlib.dnetexploremetrics.model.Metrics;
import jakarta.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@EnableScheduling
@Service
public class MetricsService {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private MetricsDAO metricsDAO;
    @Value(value="${search.service.api.url:https://services.openaire.eu/portal-search/}")
    private String searchUrl;
    private final String recordsRequest = "researchProducts/search?size=0";
    private final String publicationsRequest = "researchProducts/search?type=publication&size=0";
    private final String datasetsRequest = "researchProducts/search?type=dataset&size=0";
    private final String softwareRequest = "researchProducts/search?type=software&size=0";
    private final String orpRequest = "researchProducts/search?type=other&size=0";
    private final String fundersRequest = "browseAll/researchProducts/relfunder";
    private final String projectsRequest = "projects/search?size=0";
    private final String contentProvidersRequest = "datasources/search?size=0";
    private final String organizationsRequest = "organizations/search?size=0";

    @PostConstruct
    public void init() {
        this.calculateMetrics();
    }

    @Scheduled(cron="${calculation.time.cron}")
    private void calculateMetrics() {
        this.logger.info((Object)"Calculating metrics...");
        Metrics metrics = new Metrics();
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.getForEntity(this.searchUrl + "researchProducts/search?size=0", String.class, new Object[0]);
        JSONObject jsonObject = new JSONObject((String)response.getBody());
        metrics.records = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "researchProducts/search?type=publication&size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.publications = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "researchProducts/search?type=dataset&size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.datasets = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "researchProducts/search?type=software&size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.software = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "researchProducts/search?type=other&size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.orp = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "browseAll/researchProducts/relfunder", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.funders = jsonObject.getJSONObject("body").getJSONObject("facetResponse").getJSONObject("facets").getJSONArray("relfunder").length() + "";
        response = restTemplate.getForEntity(this.searchUrl + "projects/search?size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.projects = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "datasources/search?size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.contentProviders = jsonObject.getJSONObject("header").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "organizations/search?size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.organizations = jsonObject.getJSONObject("header").get("total").toString();
        this.metricsDAO.save(metrics);
    }

    public String getMetrics() {
        return this.metricsDAO.getMetrics();
    }
}

