package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;

import eu.dnetlib.enabling.database.DataSourceFactory;
import eu.dnetlib.enabling.database.utils.JdbcTemplateFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 23/06/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class ClaimDatabaseUtils {

	@Autowired
	private JdbcTemplateFactory claimsJdbcTemplateFactory;
	@Autowired
	private DataSourceFactory claimsDataSourceFactory;

	private JdbcTemplate jdbcTemplate;

	@Value("${dnet.openaire.claims.db.name}")
	private String dbName;

	@PostConstruct
	public void init() {
		claimsJdbcTemplateFactory.setDataSourceFactory(claimsDataSourceFactory);
		this.jdbcTemplate = claimsJdbcTemplateFactory.createJdbcTemplate(dbName);
	}

	public int count(final String sqlCountQuery) {
		return jdbcTemplate.queryForObject(sqlCountQuery, Integer.class);
	}

	public Stream<Claim> query(final String sqlQuery) {
		final SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlQuery);
		return StreamSupport.stream(
				Spliterators.spliteratorUnknownSize(
					new Iterator<Claim>() {

						@Override
						public boolean hasNext() {
							return !rowSet.isLast();
						}

						@Override
						public Claim next() {
							if (!rowSet.next()) {
								throw new NoSuchElementException();
							}
							return asClaim(rowSet);
						}
					},
					Spliterator.IMMUTABLE), false);
	}

	private Claim asClaim(SqlRowSet rs) {
		return new Claim()
				.setSemantics(rs.getString("semantics"))
				.setSource(rs.getString("source_id")).setSourceType(rs.getString("source_type"))
				.setTarget(rs.getString("target_id")).setTargetType(rs.getString("target_type"));
	}

}
