package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareContextDbEntriesJobNode extends SimpleJobNode {

	private String contextObj;
	private String eprParam;

	private static final Log log = LogFactory.getLog(PrepareContextDbEntriesJobNode.class);

	@Resource
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final ContextDesc desc = (ContextDesc) token.getEnv().getTransientAttribute(contextObj);

		final Iterable<String> iter = Iterables.transform(desc.getDbEntries().entrySet(), ContextUtils.getContextRowTransformer());
		final W3CEndpointReference epr = iterableResultSetFactory.createIterableResultSet(iter);

		token.getEnv().setAttribute(eprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
