package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class EndReadingMDStoreJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(EndReadingMDStoreJobNode.class);

    /* Spring managed params */
    private String mdStoreManagerUrl;

    @Override
    protected String execute(final NodeToken token) throws Exception {
        final String url = getMdStoreManagerUrl() + "/version/{versionId}/endReading";

        final Map<String, Object> params = new HashMap<>();
        params.put("versionId", token.getEnv().getAttribute("reading_versionId"));

        final URI uri = UriComponentsBuilder.fromUriString(url)
                .buildAndExpand(params)
                .toUri();

        final RestTemplate restTemplate = new RestTemplate();
        restTemplate.getForObject(uri, MDStoreVersion.class);

        log.info("mdstore version read complete ");
        return Arc.DEFAULT_ARC;
    }

    public String getMdStoreManagerUrl() {
        return mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }

}
