<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
                exclude-result-prefixes="fn">

    <xsl:variable name="namespacePrefix" select="string('gsri________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::GSRI')"/>

    <xsl:template match="/">
        <fundingtree>
            <funder>
                <id>
                    <xsl:value-of select="$funderID"/>
                </id>
                <shortname>GSRI</shortname>
                <name>General Secretariat of Research and Innovation (GSRI)</name>
                <originalname>General Secretariat of Research and Innovation</originalname>
                <jurisdiction>GR</jurisdiction>
            </funder>

        </fundingtree>

    </xsl:template>

</xsl:stylesheet>