INSERT INTO dsm_datasources (id, officialname, namespaceprefix, typology)
VALUES
    ('openaire____::nserc', 'Natural Sciences and Engineering Research Council of Canada', 'nserc_______', 'entityregistry::projects'),
    ('openaire____::sshrc', 'Social Sciences and Humanities Research Council', 'sshrc_______', 'entityregistry::projects'),
    ('openaire____::cihr', 'Canadian Institutes of Health Research', 'cihr________','entityregistry::projects');

INSERT INTO dsm_organizations (id, legalshortname,legalname)
VALUES
    ('nserc_______::NSERC','NSERC','Natural Sciences and Engineering Research Council of Canada'),
    ('sshrc_______::SSHRC','SSHRC','Social Sciences and Humanities Research Council'),
    ('cihr________::CIHR','CIHR','Canadian Institutes of Health Research');

INSERT INTO fundingpaths (id,path,funder,jurisdiction)
VALUES
    ('nserc_______::NSERC','<fundingtree>
                    <funder>
                        <id>nserc_______::NSERC</id>
                        <shortname>NSERC</shortname>
                        <name>Natural Sciences and Engineering Research Council of Canada</name>
                        <originalname>Natural Sciences and Engineering Research Council of Canada</originalname>
                        <jurisdiction>CA</jurisdiction>
                    </funder>
                </fundingtree>', 'nserc_______::NSERC','CA'),
    ('sshrc_______::SSHRC','<fundingtree>
                    <funder>
                        <id>sshrc_______::SSHRC</id>
                        <shortname>SSHRC</shortname>
                        <name>Social Sciences and Humanities Research Council</name>
                        <originalname>Social Sciences and Humanities Research Council</originalname>
                        <jurisdiction>CA</jurisdiction>
                    </funder>
                </fundingtree>', 'sshrc_______::SSHRC','CA'),
    ('cihr________::CIHR','<fundingtree>
                    <funder>
                        <id>cihr________::CIHR</id>
                        <shortname>CIHR</shortname>
                        <name>Canadian Institutes of Health Research</name>
                        <originalname>Canadian Institutes of Health Research</originalname>
                        <jurisdiction>CA</jurisdiction>
                    </funder>
                </fundingtree>', 'cihr________::CIHR','CA');

INSERT INTO projects (id, code, title, collectedfrom, provenanceactionclass)
VALUES
    ('nserc_______::unidentified', 'unidentified', 'unidentified', 'openaire__::nserc', 'sysimport:crosswalk:entityregistry'),
    ('sshrc_______::unidentified', 'unidentified', 'unidentified', 'openaire__::sshrc', 'sysimport:crosswalk:entityregistry'),
    ('cihr________::unidentified', 'unidentified', 'unidentified', 'openaire__::cihr', 'sysimport:crosswalk:entityregistry');

INSERT INTO project_fundingpath (funding, project)
VALUES
    ('nserc_______::NSERC', 'nserc_______::unidentified'),
    ('sshrc_______::SSHRC', 'sshrc_______::unidentified'),
    ('cihr________::CIHR', 'cihr________::unidentified');


