package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import java.io.File;
import java.util.Iterator;

public abstract class IteratorRepository implements Iterator<String>, Iterable<String> {

	protected Iterator<File> input;
	protected Iterable<File> inputIterable;
	protected String repositoryPrefix;
	protected String oaiPrefix;

	abstract String generateNextElement();

	public IteratorRepository(final Iterable<File> input, final String repositoryPrefix, final String oaiPrefix) {
		this.inputIterable = input;
		this.repositoryPrefix = repositoryPrefix;
		this.oaiPrefix = oaiPrefix;
	}

	@Override
	public boolean hasNext() {
		return input.hasNext();
	}

	@Override
	public String next() {
		return generateNextElement();
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub
	}

	@Override
	public Iterator<String> iterator() {
		this.input = inputIterable.iterator();
		return this;
	}

}
