package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import java.io.File;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;

public class PUMAIteratorRepository extends IteratorRepository {

	public PUMAIteratorRepository(final Iterable<File> input, final String repositoryPrefix, final String oaiPrefix) {
		super(input, repositoryPrefix, oaiPrefix);
		// TODO Auto-generated constructor stub
	}

	@Override
	String generateNextElement() {
		try {
			String inputname = input.next().getCanonicalPath();
			String[] values = inputname.split("/");
			if (values.length > 1) {
				ObjectStoreFile info = new ObjectStoreFile();
				String fileName = values[values.length - 1].replace(".pdf", "");
				info.setAccessProtocol(Protocols.None);
				info.setObjectID(fileName);
				info.setDownloadedURL("  ");
				info.setMimeType("pdf");
				info.setURI(inputname);
				return info.toJSON();
			}
		} catch (Exception e) {
			return null;
		}
		return null;
	}

}
