/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp.message;

import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.msro.rmi.MSROException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DnetMessageManager {
    private static final Log log = LogFactory.getLog(DnetMessageManager.class);
    private final Map<String, Message> ongoingMessages = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, Message> reportMessages = Collections.synchronizedMap(new LinkedHashMap());
    private long maxNumberOfMessages;

    public synchronized void registerMessage(Message message) throws MSROException {
        log.debug((Object)String.format("Received %s message wfId: %s", message.getMessageType(), message.getWorkflowId()));
        if (Objects.isNull(message.getMessageType())) {
            throw new MSROException("missing message type in: " + message.toString());
        }
        switch (message.getMessageType()) {
            case ONGOING: {
                this.ongoingMessages.put(message.getWorkflowId(), message);
                if ((long)this.ongoingMessages.size() <= this.maxNumberOfMessages) break;
                this.ongoingMessages.remove(this.ongoingMessages.keySet().iterator().next());
                break;
            }
            case REPORT: {
                this.reportMessages.put(message.getWorkflowId(), message);
                if ((long)this.reportMessages.size() <= this.maxNumberOfMessages) break;
                this.reportMessages.remove(this.reportMessages.keySet().iterator().next());
                break;
            }
            default: {
                throw new MSROException("message type not managed: " + message.getMessageType());
            }
        }
    }

    public Message findOngoingMessage(String workflowId) {
        return this.ongoingMessages.get(workflowId);
    }

    public Message findReportMessage(String workflowId) {
        return this.reportMessages.get(workflowId);
    }

    protected Map<String, Message> getOngoingMessages() {
        return this.ongoingMessages;
    }

    protected Map<String, Message> getReportMessages() {
        return this.reportMessages;
    }

    public long getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    @Required
    public void setMaxNumberOfMessages(long maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }
}

