/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.dhp.schema.mdstore.ValidationType;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class VerifyValidationAlertsSubscriptionJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(VerifyValidationAlertsSubscriptionJobNode.class);
    @Value(value="${dnet.openaire.dhp.validationAlerts.broker.url}")
    private String brokerBaseUrl;

    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getEnv().getAttribute("parentDatasourceId");
        String subscribers = token.getEnv().getAttribute("subscribers");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dsId, subscribers})) {
            for (String subscriber : subscribers.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)subscriber)) continue;
                for (ValidationType type : ValidationType.values()) {
                    this.performSubscription(dsId, subscriber.trim(), type);
                }
            }
        }
        return Arc.DEFAULT_ARC;
    }

    protected void performSubscription(String dsId, String subscriber, ValidationType type) {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.brokerBaseUrl + "/api/openaire-alerts/subscribe/" + type;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"email", (Object)subscriber);
        map.add((Object)"dsId", (Object)dsId);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        }
        catch (Throwable e) {
            String message;
            if (e instanceof HttpStatusCodeException && (message = ((HttpStatusCodeException)e).getResponseBodyAsString()) != null && StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"already subscribed")) {
                log.debug((Object)"The subscription has been already registered");
                return;
            }
            log.error((Object)"Subscription failed", e);
            throw e;
        }
    }

    public String getBrokerBaseUrl() {
        return this.brokerBaseUrl;
    }

    public void setBrokerBaseUrl(String brokerBaseUrl) {
        this.brokerBaseUrl = brokerBaseUrl;
    }
}

