<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_ENV_TRANSFORMATION"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_ENV_TRANSFORMATION" type="PrepareEnvTransformHadoopJobNode">
    <DESCRIPTION>Retrieve all the parameters needed to run the transformation workflow</DESCRIPTION>
    <PARAMETERS>
        <PARAM category="TRANSFORMATION_RULE_ID" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" managedBy="user" name="ruleId" required="true" type="string"></PARAM>
        <PARAM required="true" type="string" name="mdstoreInput" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
        <PARAM required="true" type="string" name="mdstoreOutput" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="TRANSFORM_HADOOP"/>
    </ARCS>
</NODE>

<NODE name="TRANSFORM_HADOOP" type="SubmitDnetHadoopJobNode">
    <DESCRIPTION>Start the Hadoop Job</DESCRIPTION>
    <PARAMETERS>
        <PARAM managedBy="system" name="hadoopJob" required="true" type="string">executeOozieJob</PARAM>
        <PARAM managedBy="user" name="cluster" required="true" type="string" function="validValues(['IIS','DHP'])">IIS</PARAM>
        <PARAM managedBy="system" name="envParams" required="true" type="string">
            {
                "mdStoreInputId":"mdstoreInput",
                "mdStoreOutputId":"mdstoreOutput",
                "transformationRuleId":"transformationRule",
                "dateOfTransformation":"timestamp",
                "workflowId":"workflowId",
                "oozie.wf.application.path":"oozieWfPath"
            }
        </PARAM>
        <PARAM managedBy="system" name="params" required="true" type="string">
            {
                 'transformationPlugin':'XSLT_TRANSFORM'
            }
        </PARAM>
        <PARAM managedBy="system" name="oozieReportActionsCsv" required="true" type="string">CommitVersion</PARAM>
    </PARAMETERS>
    <ARCS>
        <ARC to="UPDATE_INFO"/>
    </ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraFieldHadoop">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>

