/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.controllers;

import eu.dnetlib.irishmonitorservice.entities.SortBy;
import eu.dnetlib.irishmonitorservice.entities.StakeholderExtended;
import eu.dnetlib.irishmonitorservice.services.StakeholderExtendedService;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"extended"})
public class StakeholderExtendedController {
    private final StakeholderExtendedService service;

    @Autowired
    public StakeholderExtendedController(StakeholderExtendedService service) {
        this.service = service;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseEntity<List<StakeholderExtended>> getStakeholders(@RequestParam(value="type") String type, @RequestParam(value="sort", required=false) SortBy sort) throws UnsupportedEncodingException {
        return ResponseEntity.ok((Object)this.service.sortBy(this.service.getVisibleStakeholdersExtended(type), sort));
    }

    @RequestMapping(value={"/{stakeholderId}"}, method={RequestMethod.GET})
    public ResponseEntity<StakeholderExtended> getStakeholder(@PathVariable String stakeholderId) throws UnsupportedEncodingException {
        return ResponseEntity.ok((Object)this.service.getStakeholderExtended(stakeholderId));
    }

    @RequestMapping(value={"/calculate"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasAuthority(@AuthorizationService.PORTAL_ADMIN)")
    public ResponseEntity<Void> calculate() {
        this.service.calculate();
        return ResponseEntity.noContent().build();
    }
}

