/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.configuration.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.irishmonitorservice.dao"}, mongoTemplateRef="irishTemplate")
public class IrishMongoConnection {
    private final MongoConfig mongoConfig;

    @Autowired
    public IrishMongoConnection(MongoConfig mongoConfig) {
        this.mongoConfig = mongoConfig;
    }

    @Bean(name={"irishDatabaseFactory"})
    public MongoDatabaseFactory databaseFactory(@Qualifier(value="irishClient") MongoClient mongoClient) {
        return new SimpleMongoClientDatabaseFactory(mongoClient, this.mongoConfig.getDatabase());
    }

    @Bean(name={"irishMappingContext"})
    public MongoMappingContext mongoMappingContext() {
        return new MongoMappingContext();
    }

    @Bean(name={"irishMappingConverter"})
    public MappingMongoConverter mappingMongoConverter(@Qualifier(value="irishDatabaseFactory") MongoDatabaseFactory factory, @Qualifier(value="irishMappingContext") MongoMappingContext context) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        return new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
    }

    @Bean(name={"irishTemplate"})
    public MongoTemplate getMongoTemplate(@Qualifier(value="irishClient") MongoClient mongoClient) {
        return new MongoTemplate(mongoClient, this.mongoConfig.getDatabase());
    }

    @Bean(name={"irishClient"})
    public MongoClient getMongoClient() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(new ServerAddress(this.mongoConfig.getHost(), this.mongoConfig.getPort()))));
        if (this.mongoConfig.getUsername() != null && this.mongoConfig.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getDatabase(), (char[])this.mongoConfig.getPassword().toCharArray());
            builder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

