/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.exception;

import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.exception.SyntaxErrorException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class FacetExceptionHandling {
    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<Map<String, String>> handleValidationExceptions(ConstraintViolationException constraintViolationException) {
        HashMap errors = new HashMap();
        constraintViolationException.getConstraintViolations().forEach(error -> errors.put("error_message", error.getMessage()));
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SyntaxErrorException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<Map<String, String>> handleValidationExceptions(SyntaxErrorException syntaxErrorException) {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", syntaxErrorException.getMessage());
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<Map<String, String>> handleValidationBindException(BindException bindException) {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", bindException.getBindingResult().getFieldError().getDefaultMessage());
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DocumentNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<Map<String, String>> handleDocumentNotFoundExceptions(DocumentNotFoundException documentNotFoundException) {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", documentNotFoundException.getMessage());
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<Object> handleValidationExceptions(MethodArgumentNotValidException ex) {
        List errors = ex.getBindingResult().getFieldErrors().stream().map(error -> error.getField() + ": " + error.getDefaultMessage()).collect(Collectors.toList());
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotReadablePropertyException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<Map<String, String>> notReadablePropertyExceptions(NotReadablePropertyException notReadablePropertyException) {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", notReadablePropertyException.getMessage());
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

