/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.OrganizationRequest;
import eu.dnetlib.dto.request.validators.EntityFieldConstraint;
import eu.dnetlib.dto.request.validators.FacetFieldValueContraint;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.services.CsvDownloadService;
import eu.dnetlib.services.OrganizationService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.validation.Valid;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/organizations"})
@Validated
public class OrganizationController
extends EntityController {
    @Autowired
    OrganizationService organizationService;
    @Autowired
    CsvDownloadService downloadService;

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public String getById(@PathVariable String id) throws SolrServerException, IOException {
        OrganizationRequest organizationRequest = new OrganizationRequest();
        organizationRequest.setId(new String[]{id});
        return this.organizationService.getById(organizationRequest);
    }

    @GetMapping(value={"/search"})
    public CustomSolrResponse search(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest) {
        return this.organizationService.search(organizationRequest);
    }

    @GetMapping(path={"/facetSearch"})
    public CustomSolrResponse facetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.organization) FacetRequest facetRequest) {
        return this.organizationService.facetSearch(organizationRequest, facetRequest, Integer.valueOf(10));
    }

    @GetMapping(path={"/defaultFacetSearch"})
    public CustomSolrResponse defaultFacetSearch(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, @Valid @FacetFieldValueContraint(type=FacetRequest.Type.organization) FacetRequest facetRequest) {
        return this.organizationService.facetSearch(organizationRequest, facetRequest, Integer.valueOf(100));
    }

    @GetMapping(path={"/fetchCsv"}, produces={"application/octet-stream"})
    public void streamCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"organizations.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)organizationRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"organizations.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamCsv((EntityRequest)organizationRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialCsv"}, produces={"application/octet-stream"})
    public void streamSpecialCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"organizations.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)organizationRequest, (OutputStream)outputStream, true);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }

    @GetMapping(path={"/fetchSpecialNoTitleCsv"}, produces={"application/octet-stream"})
    public void streamSpecialNoTitleCsv(@Valid @EntityFieldConstraint(type=EntityRequest.Type.organization) OrganizationRequest organizationRequest, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"organizations.csv\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.downloadService.streamSpecialCsv((EntityRequest)organizationRequest, (OutputStream)outputStream, false);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }
}

