/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.solr.Person;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.PersonRequest;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.response.CustomSolrBodyMapper;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonService {
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;
    @Autowired
    CustomSolrBodyMapper customSolrBodyMapper;
    final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public Person getById(PersonRequest personRequest) throws JsonProcessingException {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)personRequest);
        System.out.println("love > " + String.valueOf(customSolrParams.getBasicSolrQuery()));
        System.out.println("hate > " + String.valueOf(customSolrParams.getFacetFields()));
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Person with id: " + personRequest.getId()[0] + " not found.");
        }
        String personString = this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
        SolrRecord solrRecord = (SolrRecord)this.objectMapper.readValue(personString, SolrRecord.class);
        return solrRecord.getPerson();
    }
}

