/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.Instance;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.RecordType;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.RelatedRecordHeader;
import eu.dnetlib.dhp.schema.solr.Result;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.response.sygma.SygmaDataset;
import eu.dnetlib.dto.response.sygma.SygmaHeader;
import eu.dnetlib.dto.response.sygma.SygmaPublication;
import eu.dnetlib.dto.response.sygma.SygmaResponse;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SygmaService {
    @Autowired
    private SolrRepository solrRepository;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    private final ObjectMapper jsonMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final XmlMapper xmlMapper = new XmlMapper();

    public String searchPublications(ResearchProductRequest researchProductRequest) throws IOException {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)researchProductRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        List jsonResults = queryResponse.getResults().stream().map(doc -> (String)doc.get((Object)"__json")).collect(Collectors.toList());
        SygmaResponse sygmaResponse = new SygmaResponse();
        SygmaHeader header = SygmaService.generateSygmaHeader((ResearchProductRequest)researchProductRequest, (QueryResponse)queryResponse);
        sygmaResponse.setHeader(header);
        sygmaResponse.setPublications(new ArrayList());
        for (String resultString : jsonResults) {
            SolrRecord solrRecord = (SolrRecord)this.jsonMapper.readValue(resultString, SolrRecord.class);
            SygmaPublication sygmaPublication = SygmaService.generateSygmaPublication((SolrRecord)solrRecord);
            sygmaResponse.getPublications().add(sygmaPublication);
        }
        this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return this.xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)sygmaResponse);
    }

    public String searchDatasets(ResearchProductRequest researchProductRequest) throws IOException {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)researchProductRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        List jsonResults = queryResponse.getResults().stream().map(doc -> (String)doc.get((Object)"__json")).collect(Collectors.toList());
        SygmaResponse sygmaResponse = new SygmaResponse();
        SygmaHeader header = SygmaService.generateSygmaHeader((ResearchProductRequest)researchProductRequest, (QueryResponse)queryResponse);
        sygmaResponse.setHeader(header);
        sygmaResponse.setDatasets(new ArrayList());
        for (String resultString : jsonResults) {
            SolrRecord solrRecord = (SolrRecord)this.jsonMapper.readValue(resultString, SolrRecord.class);
            SygmaDataset sygmaDataset = SygmaService.generateSygmaDataset((SolrRecord)solrRecord);
            sygmaResponse.getDatasets().add(sygmaDataset);
        }
        return this.xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)sygmaResponse);
    }

    private static SygmaHeader generateSygmaHeader(ResearchProductRequest researchProductRequest, QueryResponse queryResponse) {
        SygmaHeader header = new SygmaHeader();
        header.setPage("" + (researchProductRequest.getPage() + 1));
        header.setSize(researchProductRequest.getSize().toString());
        header.setTotal("" + queryResponse.getResults().getNumFound());
        return header;
    }

    private static SygmaPublication generateSygmaPublication(SolrRecord solrRecord) {
        Result solrResult = solrRecord.getResult();
        SygmaPublication sygmaPublication = new SygmaPublication();
        sygmaPublication.setOpenaireid(solrRecord.getHeader().getId());
        List dois = Optional.ofNullable(solrRecord.getPid()).orElse(Collections.emptyList()).stream().filter(p -> "doi".equalsIgnoreCase(p.getTypeCode())).map(Pid::getValue).collect(Collectors.toList());
        sygmaPublication.setDoi(dois);
        if (solrResult.getDescription() != null && !solrResult.getDescription().isEmpty()) {
            sygmaPublication.setDescription((String)solrResult.getDescription().get(0));
        }
        sygmaPublication.setPublicationtype(((Instance)solrResult.getInstance().get(0)).getInstancetype());
        if (solrResult.getMaintitle() != null) {
            sygmaPublication.setTitle(solrResult.getMaintitle());
        } else if (solrResult.getOtherTitles() != null && !solrResult.getOtherTitles().isEmpty()) {
            sygmaPublication.setTitle((String)solrResult.getOtherTitles().get(0));
        }
        List authorNames = Optional.ofNullable(solrResult.getAuthor()).orElse(Collections.emptyList()).stream().sorted(Comparator.comparing(Author::getRank)).map(Author::getFullname).collect(Collectors.toList());
        sygmaPublication.setAuthors(authorNames);
        if (solrResult.getJournal() != null) {
            sygmaPublication.setSourcejournal(List.of(solrResult.getJournal().getName()));
        } else if (solrResult.getSource() != null && !solrResult.getSource().isEmpty()) {
            sygmaPublication.setSourcejournal(solrResult.getSource());
        }
        sygmaPublication.setDateofacceptance(solrResult.getPublicationdate());
        List urls = solrResult.getInstance().stream().map(Instance::getUrl).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        sygmaPublication.setWebresource(urls);
        sygmaPublication.setBestlicense(solrResult.getBestaccessright().getLabel());
        return sygmaPublication;
    }

    private static SygmaDataset generateSygmaDataset(SolrRecord solrRecord) {
        Result solrResult = solrRecord.getResult();
        SygmaDataset sygmaDataset = new SygmaDataset();
        sygmaDataset.setOpenaireid(solrRecord.getHeader().getId());
        List dois = Optional.ofNullable(solrRecord.getPid()).orElse(Collections.emptyList()).stream().filter(p -> "doi".equalsIgnoreCase(p.getTypeCode())).map(Pid::getValue).collect(Collectors.toList());
        sygmaDataset.setDoi(dois);
        if (solrResult.getDescription() != null && !solrResult.getDescription().isEmpty()) {
            sygmaDataset.setDescription((String)solrResult.getDescription().get(0));
        }
        sygmaDataset.setPublicationType(((Instance)solrResult.getInstance().get(0)).getInstancetype());
        if (solrResult.getMaintitle() != null) {
            sygmaDataset.setTitle(solrResult.getMaintitle());
        } else if (solrResult.getOtherTitles() != null && !solrResult.getOtherTitles().isEmpty()) {
            sygmaDataset.setTitle((String)solrResult.getOtherTitles().get(0));
        }
        List authorNames = Optional.ofNullable(solrResult.getAuthor()).orElse(Collections.emptyList()).stream().sorted(Comparator.comparing(Author::getRank)).map(Author::getFullname).collect(Collectors.toList());
        sygmaDataset.setAuthors(authorNames);
        sygmaDataset.setBestlicense(solrResult.getBestaccessright().getLabel());
        sygmaDataset.setRelatedPublications(new ArrayList());
        List urls = solrResult.getInstance().stream().map(Instance::getUrl).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        sygmaDataset.setWebresource(urls);
        ArrayList<SygmaPublication> relatedPublications = new ArrayList<SygmaPublication>();
        List links = Optional.ofNullable(solrRecord.getLinks()).orElse(Collections.emptyList());
        for (RelatedRecord relatedRecord : links) {
            RelatedRecordHeader header = relatedRecord.getHeader();
            String relationClass = header != null ? header.getRelationClass() : null;
            RecordType recordType = header.getRelatedRecordType();
            if (!"IsRelatedTo".equals(relationClass) || recordType != null && !"publication".equals(recordType.toString())) continue;
            SygmaPublication relatedPublication = new SygmaPublication();
            if (header != null) {
                relatedPublication.setOpenaireid(header.getRelatedIdentifier());
                RecordType type = header.getRelatedRecordType();
                relatedPublication.setPublicationtype(type != null ? type.name() : null);
            }
            relatedPublication.setTitle(relatedRecord.getTitle());
            relatedPublication.setDateofacceptance(relatedRecord.getDateofacceptance());
            if (relatedRecord.getAuthor() != null && !relatedRecord.getAuthor().isEmpty()) {
                relatedPublication.setAuthors(relatedRecord.getAuthor());
            }
            relatedPublication.setDescription(relatedRecord.getDescription());
            relatedPublications.add(relatedPublication);
        }
        sygmaDataset.setRelatedPublications(relatedPublications);
        return sygmaDataset;
    }
}

