/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/*
 * Exception performing whole class analysis ignored.
 */
@Mapper(componentModel="spring")
public interface ResearchProductRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.researchProductFieldMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.researchProductIdFieldMapping;
    public static final List<String> defaultFq = SolrQueryMapper.researchProductDefaultFqMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.researchProductSortMapping;
    public static final Map<String, String> bestAccessRightLabelMapping = Map.of("OPEN SOURCE", "\"Open Source\"", "OPEN", "\"Open Access\"", "EMBARGO", "\"Embargo\"", "RESTRICTED", "\"Restricted\"", "CLOSED", "\"Closed Access\"", "UNKNOWN", "\"not available\"");
    public static final ResearchProductRequestMapper INSTANCE = (ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class);

    @Mappings(value={@Mapping(target="query", expression="java(extractQuery(researchProductsRequest))"), @Mapping(target="fq", expression="java(extractFq(researchProductsRequest))")})
    public BasicSolrQuery toBasicSolrQuery(ResearchProductRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java(extractQuery(researchProductsRequest, true))"), @Mapping(target="fq", expression="java(extractFq(researchProductsRequest, true))")})
    public BasicSolrQuery toBasicSolrOrQuery(ResearchProductRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java(extractIdQuery(researchProductsRequest))"), @Mapping(target="fq", expression="java( extractFq(researchProductsRequest))")})
    public BasicSolrQuery toBasicIdSolrQuery(ResearchProductRequest var1);

    default public String extractQuery(ResearchProductRequest researchProductsRequest) {
        ArrayList qList = new ArrayList();
        ResearchProductRequestMapper.enhanceWithSimpleFields((ResearchProductRequest)researchProductsRequest, qList);
        return String.join((CharSequence)" AND ", qList);
    }

    default public String extractOrQuery(ResearchProductRequest researchProductsRequest) {
        ArrayList qList = new ArrayList();
        ResearchProductRequestMapper.enhanceWithSimpleFields((ResearchProductRequest)researchProductsRequest, qList);
        return String.join((CharSequence)" OR ", qList);
    }

    private static void enhanceWithSimpleFields(ResearchProductRequest researchProductsRequest, ArrayList<String> qList) {
        if (!Utils.isNullOrEmpty((String)researchProductsRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)researchProductsRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        if (!Utils.isNullOrEmpty((String)researchProductsRequest.getMainTitle())) {
            qList.add(String.format((String)solrFieldMapping.get("mainTitle"), Utils.validateAndClean((String)researchProductsRequest.getMainTitle()), "OR"));
        }
        if (!Utils.isNullOrEmpty((String)researchProductsRequest.getDescription())) {
            qList.add(String.format((String)solrFieldMapping.get("description"), Utils.validateAndClean((String)researchProductsRequest.getDescription()), "OR"));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getAuthorFullName())) {
            qList.add(String.format((String)solrFieldMapping.get("authorFullName"), Utils.escapeAndJoin((String[])researchProductsRequest.getAuthorFullName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((Boolean)researchProductsRequest.getHasProjectRel())) {
            if (researchProductsRequest.getHasProjectRel().booleanValue()) {
                qList.add((String)solrFieldMapping.get("hasProjectRel"));
            } else {
                qList.add("-" + (String)solrFieldMapping.get("hasProjectRel"));
            }
        }
        if (!Utils.isNullOrEmpty((Boolean)researchProductsRequest.getHasFunderRel())) {
            if (researchProductsRequest.getHasFunderRel().booleanValue()) {
                qList.add((String)solrFieldMapping.get("hasFunderRel"));
            } else {
                qList.add("-" + (String)solrFieldMapping.get("hasFunderRel"));
            }
        }
        if (!Utils.isNullOrEmpty((String)researchProductsRequest.getSource())) {
            qList.add(String.format((String)solrFieldMapping.get("source"), Utils.validateAndClean((String)researchProductsRequest.getSource()), Utils.validateAndClean((String)researchProductsRequest.getSource())));
        }
    }

    default public String extractQuery(ResearchProductRequest researchProductsRequest, boolean isOr) {
        if (isOr) {
            ArrayList fqList = new ArrayList();
            ResearchProductRequestMapper.enhanceWithFq((ResearchProductRequest)researchProductsRequest, fqList);
            System.out.println("Will return " + String.join((CharSequence)" AND ", this.extractOrQuery(researchProductsRequest) + String.join((CharSequence)" OR ", this.extractFq(researchProductsRequest, isOr))));
            return this.extractOrQuery(researchProductsRequest) + " AND " + String.join((CharSequence)" OR ", fqList);
        }
        return this.extractQuery(researchProductsRequest);
    }

    default public String extractIdQuery(ResearchProductRequest researchProductRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (researchProductRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("id"), Utils.escapeAndJoin((String[])researchProductRequest.getId(), (String)"OR")));
        idList.add(String.format((String)idFieldMapping.get("dupid"), Utils.escapeAndJoin((String[])researchProductRequest.getId(), (String)"OR")));
        return String.join((CharSequence)" OR ", idList);
    }

    default public List<String> extractFq(ResearchProductRequest researchProductsRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        ResearchProductRequestMapper.enhanceWithFq((ResearchProductRequest)researchProductsRequest, fqList);
        return fqList;
    }

    default public List<String> extractFq(ResearchProductRequest researchProductsRequest, boolean isOr) {
        if (isOr) {
            ArrayList<String> fqList = new ArrayList<String>();
            fqList.addAll(defaultFq);
            return fqList;
        }
        return this.extractFq(researchProductsRequest);
    }

    private static void enhanceWithFq(ResearchProductRequest researchProductsRequest, ArrayList<String> fqList) {
        String relProjectFundingStreamId;
        if (!Utils.isNullOrEmpty((String)researchProductsRequest.getObjIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("objIdentifier"), Utils.validateAndClean((String)researchProductsRequest.getObjIdentifier())));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getOriginalId())) {
            fqList.add(String.format((String)solrFieldMapping.get("originalId"), Utils.escapeAndJoin((String[])researchProductsRequest.getOriginalId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getPid())) {
            fqList.add(String.format((String)solrFieldMapping.get("pid"), Utils.escapeAndJoin((String[])researchProductsRequest.getPid(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getType())) {
            fqList.add(String.format((String)solrFieldMapping.get("type"), Utils.escapeAndJoin((String[])researchProductsRequest.getType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getEoscIfGuidelines())) {
            fqList.add(String.format((String)solrFieldMapping.get("eoscIfGuidelines"), Utils.escapeAndJoin((String[])researchProductsRequest.getEoscIfGuidelines(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getCountryCode())) {
            fqList.add(String.format((String)solrFieldMapping.get("countryCode"), Utils.escapeAndJoin((String[])researchProductsRequest.getCountryCode(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getCountry())) {
            fqList.add(String.format((String)solrFieldMapping.get("countryCode"), Utils.escapeAndJoin((String[])researchProductsRequest.getCountry(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getAuthorId())) {
            fqList.add(String.format((String)solrFieldMapping.get("authorId"), Utils.escapeAndJoin((String[])researchProductsRequest.getAuthorId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getAuthorOrcid())) {
            ArrayList<String> expressionParts = new ArrayList<String>();
            for (String authorOrcidRaw : researchProductsRequest.getAuthorOrcid()) {
                String[] rawTokens = authorOrcidRaw.split("(?i)\\b(AND|OR|NOT)\\b");
                Matcher opMatcher = Pattern.compile("(?i)\\b(AND|OR|NOT)\\b").matcher(authorOrcidRaw);
                ArrayList<String> operators = new ArrayList<String>();
                while (opMatcher.find()) {
                    operators.add(opMatcher.group().toUpperCase());
                }
                List processedTokens = Arrays.stream(rawTokens).map(String::trim).filter(s -> !s.isEmpty()).map(s -> {
                    if (Utils.isQuoted((String)s)) {
                        int lastQuoteIndex = s.lastIndexOf("\"");
                        return s.substring(0, lastQuoteIndex) + "||orcid" + s.substring(lastQuoteIndex);
                    }
                    return "\"" + s + "||orcid\"";
                }).collect(Collectors.toList());
                StringBuilder combined = new StringBuilder();
                for (int i = 0; i < processedTokens.size(); ++i) {
                    combined.append((String)processedTokens.get(i));
                    if (i >= operators.size()) continue;
                    combined.append(" ").append((String)operators.get(i)).append(" ");
                }
                expressionParts.add(combined.toString());
            }
            String finalExpression = String.join((CharSequence)" OR ", expressionParts);
            fqList.add(String.format((String)solrFieldMapping.get("authorOrcid"), finalExpression));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getSubCommunity())) {
            fqList.add(String.format((String)solrFieldMapping.get("subCommunity"), Utils.escapeAndJoin((String[])researchProductsRequest.getSubCommunity(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getBestOpenAccessRightLabel())) {
            String[] mappedBestAccessRightLabels = (String[])Arrays.stream(researchProductsRequest.getBestOpenAccessRightLabel()).map(s -> bestAccessRightLabelMapping.getOrDefault(s, s)).toArray(String[]::new);
            fqList.add(String.format((String)solrFieldMapping.get("bestAccessRightLabel"), Utils.escapeAndJoin((String[])mappedBestAccessRightLabels, (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getSubjects())) {
            fqList.add(String.format((String)solrFieldMapping.get("subjects"), Utils.escapeAndJoin((String[])researchProductsRequest.getSubjects(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getPublisher())) {
            fqList.add(String.format((String)solrFieldMapping.get("publisher"), Utils.escapeAndJoin((String[])researchProductsRequest.getPublisher(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getInfluenceClass())) {
            fqList.add(String.format((String)solrFieldMapping.get("influence"), Utils.escapeAndJoin((String[])researchProductsRequest.getInfluenceClass(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getPopularityClass())) {
            fqList.add(String.format((String)solrFieldMapping.get("popularity"), Utils.escapeAndJoin((String[])researchProductsRequest.getPopularityClass(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getImpulseClass())) {
            fqList.add(String.format((String)solrFieldMapping.get("impulse"), Utils.escapeAndJoin((String[])researchProductsRequest.getImpulseClass(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getCitationCountClass())) {
            fqList.add(String.format((String)solrFieldMapping.get("citationCount"), Utils.escapeAndJoin((String[])researchProductsRequest.getCitationCountClass(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelResultId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relResultId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelResultId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelOrganizationId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelOrganizationId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelOrganization())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganization"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelOrganization(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelCommunityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelCommunityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelCommunityName())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityName"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelCommunityName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelFunder())) {
            fqList.add(String.format((String)solrFieldMapping.get("relFunder"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelFunder(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelProject())) {
            fqList.add(String.format((String)solrFieldMapping.get("relProject"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelProject(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelProjectId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relProjectId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelProjectId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelProjectCode())) {
            fqList.add(String.format((String)solrFieldMapping.get("relProjectCode"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelProjectCode(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelResultType())) {
            fqList.add(String.format((String)solrFieldMapping.get("relResultType"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelResultType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((Boolean)researchProductsRequest.getHasProjectRel())) {
            fqList.add(String.format((String)solrFieldMapping.get("hasProjectRel"), Utils.validateAndClean((Boolean)researchProductsRequest.getHasProjectRel())));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelProjectFundingShortName())) {
            fqList.add(String.format((String)solrFieldMapping.get("relProjectFundingShortName"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelProjectFundingShortName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelProjectFundingStreamId())) {
            relProjectFundingStreamId = Utils.escapeAndJoin((String[])researchProductsRequest.getRelProjectFundingStreamId(), (String)"OR");
            fqList.add(String.format((String)solrFieldMapping.get("relProjectFundingStreamId"), relProjectFundingStreamId, relProjectFundingStreamId, relProjectFundingStreamId));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelFundingLevel0Id())) {
            relProjectFundingStreamId = Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel0Id(), (String)"OR");
            fqList.add(String.format((String)solrFieldMapping.get("relFundingLevel0Id"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel0Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelFundingLevel1Id())) {
            relProjectFundingStreamId = Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel1Id(), (String)"OR");
            fqList.add(String.format((String)solrFieldMapping.get("relFundingLevel1Id"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel1Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelFundingLevel2Id())) {
            relProjectFundingStreamId = Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel2Id(), (String)"OR");
            fqList.add(String.format((String)solrFieldMapping.get("relFundingLevel2Id"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelFundingLevel2Id(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getLanguage())) {
            fqList.add(String.format((String)solrFieldMapping.get("language"), Utils.escapeAndJoin((String[])researchProductsRequest.getLanguage(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelHostingDataSource())) {
            fqList.add(String.format((String)solrFieldMapping.get("relHostingDataSource"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelHostingDataSource(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelHostingDataSourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relHostingDataSourceId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelHostingDataSourceId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getRelCollectedFromDatasourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCollectedFromDatasourceId"), Utils.escapeAndJoin((String[])researchProductsRequest.getRelCollectedFromDatasourceId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getInstanceType())) {
            fqList.add(String.format((String)solrFieldMapping.get("instanceType"), Utils.escapeAndJoin((String[])researchProductsRequest.getInstanceType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getSdg())) {
            fqList.add(String.format((String)solrFieldMapping.get("sdg"), Utils.escapeAndJoin((String[])researchProductsRequest.getSdg(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getFos())) {
            fqList.add(String.format((String)solrFieldMapping.get("fos"), Utils.escapeAndJoin((String[])researchProductsRequest.getFos(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getFosLabel())) {
            fqList.add(String.format((String)solrFieldMapping.get("fosLabel"), Utils.escapeAndJoin((String[])researchProductsRequest.getFosLabel(), (String)"OR")));
        }
        if (researchProductsRequest.getHasLicense() != null) {
            fqList.add(String.format((String)solrFieldMapping.get("hasLicense"), researchProductsRequest.getHasLicense()));
        }
        if (researchProductsRequest.getIsPeerReviewed() != null) {
            fqList.add(String.format((String)solrFieldMapping.get("isPeerReviewed"), researchProductsRequest.getIsPeerReviewed()));
        }
        if (researchProductsRequest.getIsInDiamondJournal() != null) {
            fqList.add(String.format((String)solrFieldMapping.get("isInDiamondJournal"), researchProductsRequest.getIsInDiamondJournal()));
        }
        if (researchProductsRequest.getIsPubliclyFunded() != null) {
            fqList.add(String.format((String)solrFieldMapping.get("isPubliclyFunded"), researchProductsRequest.getIsPubliclyFunded()));
        }
        if (researchProductsRequest.getIsGreen() != null) {
            fqList.add(String.format((String)solrFieldMapping.get("isGreen"), researchProductsRequest.getIsGreen()));
        }
        if (!Utils.isNullOrEmpty((String[])researchProductsRequest.getOpenAccessColor())) {
            fqList.add(String.format((String)solrFieldMapping.get("openAccessColor"), Utils.escapeAndJoin((String[])researchProductsRequest.getOpenAccessColor(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((LocalDate)researchProductsRequest.getFromPublicationDate()) || !Utils.isNullOrEmpty((LocalDate)researchProductsRequest.getToPublicationDate())) {
            if (!Utils.isNullOrEmpty((String)researchProductsRequest.getPubDateOp())) {
                if (researchProductsRequest.getPubDateOp().equals("NOT")) {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("notPublicationDate")), (LocalDate)researchProductsRequest.getFromPublicationDate(), (LocalDate)researchProductsRequest.getToPublicationDate()));
                } else {
                    fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("publicationDate")), (LocalDate)researchProductsRequest.getFromPublicationDate(), (LocalDate)researchProductsRequest.getToPublicationDate()));
                }
            } else {
                fqList.add(Utils.formatSolrDateRange((String)((String)solrFieldMapping.get("publicationDate")), (LocalDate)researchProductsRequest.getFromPublicationDate(), (LocalDate)researchProductsRequest.getToPublicationDate()));
            }
        }
        if (!Utils.isNullOrEmpty((Year)researchProductsRequest.getFromPublicationYear()) || !Utils.isNullOrEmpty((Year)researchProductsRequest.getToPublicationYear())) {
            fqList.add(Utils.formatSolrYearRange((String)((String)solrFieldMapping.get("publicationYear")), (Year)researchProductsRequest.getFromPublicationYear(), (Year)researchProductsRequest.getToPublicationYear()));
        }
    }

    default public SortParam extractSort(ResearchProductRequest researchProductRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = researchProductRequest.getSortBy().split(" ");
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(ResearchProductRequest researchProductRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = researchProductRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

