/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import eu.dnetlib.dto.request.DatasourceRequest;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasourceService {
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    public String getById(DatasourceRequest datasourceRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)datasourceRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Datasource with id: " + datasourceRequest.getId()[0] + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }

    public CustomSolrResponse search(DatasourceRequest datasourceRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)datasourceRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)datasourceRequest, customSolrParams);
    }

    public CustomSolrResponse facetSearch(DatasourceRequest datasourceRequest, FacetRequest facetRequest, Integer facetlimit) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)datasourceRequest, facetRequest, facetlimit);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)datasourceRequest, customSolrParams);
    }
}

