/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.request;

import eu.dnetlib.dto.request.ServiceRequest;
import eu.dnetlib.exception.SyntaxErrorException;
import eu.dnetlib.mappers.Utils;
import eu.dnetlib.mappers.solr.SolrQueryMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.SortParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface ServiceRequestMapper {
    public static final Map<String, String> solrFieldMapping = SolrQueryMapper.serviceFieldMapping;
    public static final Map<String, String> idFieldMapping = SolrQueryMapper.serviceIdFieldMapping;
    public static final List<String> defaultFq = SolrQueryMapper.serviceDefaultFqMapping;
    public static final Map<String, String> sortFieldMapping = SolrQueryMapper.serviceSortMapping;

    @Mappings(value={@Mapping(target="query", expression="java( extractQuery(serviceRequest) )"), @Mapping(target="fq", expression="java( extractFq(serviceRequest) )")})
    public BasicSolrQuery toBasicSolrQuery(ServiceRequest var1);

    @Mappings(value={@Mapping(target="query", expression="java( extractIdQuery(serviceRequest) )"), @Mapping(target="fq", expression="java( extractFq(serviceRequest) )")})
    public BasicSolrQuery toBasicIdSolrQuery(ServiceRequest var1);

    default public String extractQuery(ServiceRequest serviceRequest) {
        ArrayList<String> qList = new ArrayList<String>();
        if (!Utils.isNullOrEmpty((String)serviceRequest.getSearch())) {
            qList.add(String.format((String)solrFieldMapping.get("search"), Utils.validateAndClean((String)serviceRequest.getSearch())));
        } else {
            qList.add(String.format((String)solrFieldMapping.get("search"), "*:*"));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getOfficialName())) {
            qList.add(String.format((String)solrFieldMapping.get("officialName"), Utils.escapeAndJoin((String[])serviceRequest.getOfficialName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getEnglishName())) {
            qList.add(String.format((String)solrFieldMapping.get("englishName"), Utils.escapeAndJoin((String[])serviceRequest.getEnglishName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getRelOrganizationName())) {
            qList.add(String.format((String)solrFieldMapping.get("relOrganizationName"), Utils.escapeAndJoin((String[])serviceRequest.getRelOrganizationName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getRelOrganizationShortName())) {
            qList.add(String.format((String)solrFieldMapping.get("relOrganizationShortName"), Utils.escapeAndJoin((String[])serviceRequest.getRelOrganizationShortName(), (String)"OR")));
        }
        return String.join((CharSequence)" AND ", qList);
    }

    default public List<String> extractFq(ServiceRequest serviceRequest) {
        ArrayList<String> fqList = new ArrayList<String>();
        fqList.addAll(defaultFq);
        if (!Utils.isNullOrEmpty((String)serviceRequest.getObjIdentifier())) {
            fqList.add(String.format((String)solrFieldMapping.get("objIdentifier"), Utils.validateAndClean((String)serviceRequest.getObjIdentifier())));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getPid())) {
            fqList.add(String.format((String)solrFieldMapping.get("pid"), Utils.escapeAndJoin((String[])serviceRequest.getPid(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getSubjects())) {
            fqList.add(String.format((String)solrFieldMapping.get("subjects"), Utils.escapeAndJoin((String[])serviceRequest.getSubjects(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getDataSourceTypeName())) {
            fqList.add(String.format((String)solrFieldMapping.get("dataSourceTypeName"), Utils.escapeAndJoin((String[])serviceRequest.getDataSourceTypeName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getCollectedFromName())) {
            fqList.add(String.format((String)solrFieldMapping.get("collectedFromName"), Utils.escapeAndJoin((String[])serviceRequest.getCollectedFromName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getEoscDatasourceType())) {
            fqList.add(String.format((String)solrFieldMapping.get("eoscdatasourcetype"), Utils.escapeAndJoin((String[])serviceRequest.getEoscDatasourceType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getOdLanguages())) {
            fqList.add(String.format((String)solrFieldMapping.get("odLanguages"), Utils.escapeAndJoin((String[])serviceRequest.getOdLanguages(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getCompatibilityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("compatibilityId"), Utils.escapeAndJoin((String[])serviceRequest.getCompatibilityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getCompatibilityName())) {
            fqList.add(String.format((String)solrFieldMapping.get("compatibilityName"), Utils.escapeAndJoin((String[])serviceRequest.getCompatibilityName(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getContentTypes())) {
            fqList.add(String.format((String)solrFieldMapping.get("contentTypes"), Utils.escapeAndJoin((String[])serviceRequest.getContentTypes(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getCountry())) {
            fqList.add(String.format((String)solrFieldMapping.get("country"), Utils.escapeAndJoin((String[])serviceRequest.getCountry(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((Boolean)serviceRequest.getThematic())) {
            fqList.add(String.format((String)solrFieldMapping.get("thematic"), Utils.validateAndClean((Boolean)serviceRequest.getThematic())));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getJurisdiction())) {
            fqList.add(String.format((String)solrFieldMapping.get("jurisdiction"), Utils.escapeAndJoin((String[])serviceRequest.getJurisdiction(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getEoscType())) {
            fqList.add(String.format((String)solrFieldMapping.get("eoscType"), Utils.escapeAndJoin((String[])serviceRequest.getEoscType(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getRelOrganizationId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relOrganizationId"), Utils.escapeAndJoin((String[])serviceRequest.getRelOrganizationId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getRelCommunityId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCommunityId"), Utils.escapeAndJoin((String[])serviceRequest.getRelCommunityId(), (String)"OR")));
        }
        if (!Utils.isNullOrEmpty((String[])serviceRequest.getRelCollectedFromDatasourceId())) {
            fqList.add(String.format((String)solrFieldMapping.get("relCollectedFromDatasourceId"), Utils.escapeAndJoin((String[])serviceRequest.getRelCollectedFromDatasourceId(), (String)"OR")));
        }
        return fqList;
    }

    default public String extractIdQuery(ServiceRequest serviceRequest) {
        ArrayList<String> idList = new ArrayList<String>();
        if (serviceRequest.getId().length > 1) {
            throw new SyntaxErrorException("Illegal multiple value parameter. Id parameter must be unique.");
        }
        idList.add(String.format((String)idFieldMapping.get("id"), Utils.escapeAndJoin((String[])serviceRequest.getId(), (String)"OR")));
        return String.join((CharSequence)" OR ", idList);
    }

    default public SortParam extractSort(ServiceRequest serviceRequest) {
        SortParam sortParam = new SortParam();
        String[] sortParams = serviceRequest.getSortBy().split(" ");
        sortParam.getSort().put((String)sortFieldMapping.get(sortParams[0]), sortParams[1]);
        return sortParam;
    }

    default public List<SortParam> extractSortParams(ServiceRequest serviceRequest) {
        String[] sortByPairs;
        ArrayList<SortParam> sortParamList = new ArrayList<SortParam>();
        for (String pair : sortByPairs = serviceRequest.getSortBy().split(",")) {
            SortParam sortParam = new SortParam();
            String[] parts = pair.trim().split("\\s+");
            String field = parts[0];
            sortParam.getSort().put((String)sortFieldMapping.get(parts[0]), parts[1]);
            sortParamList.add(sortParam);
        }
        return sortParamList;
    }
}

