/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.response.CustomSolrBody;
import eu.dnetlib.helpers.html.ResearchProductHtml;
import eu.dnetlib.mappers.html.ResearchProductsHtmlMapper;
import eu.dnetlib.mappers.response.CustomSolrBodyMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import java.util.List;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HtmlDownloadService {
    private static final Logger log = LoggerFactory.getLogger(HtmlDownloadService.class);
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    CustomSolrBodyMapper customSolrBodyMapper;
    @Autowired
    ResearchProductsHtmlMapper researchProductsHtmlMapper;
    final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public String fetchHtml(EntityRequest entityRequest) {
        CustomSolrParams solrParams = this.customSolrParamsMapper.toCustomCursorSolrParams(entityRequest);
        QueryResponse queryResponse = this.solrRepository.cursorQuery(solrParams);
        CustomSolrBody solrBody = this.customSolrBodyMapper.toCustomSolrBody(queryResponse);
        List jsonResults = solrBody.getResults();
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<table>").append("<thead><tr>").append("<th>Type</th><th>Title</th><th>Authors</th><th>Publication Year</th><th>DOI</th><th>Permanent Identifier</th><th>Publication type</th><th>Journal</th><th>Project Name (GA Number)</th><th>Access Mode</th>").append("</tr></thead><tbody>");
        try {
            for (String resultString : jsonResults) {
                SolrRecord solrRecord = (SolrRecord)this.objectMapper.readValue(resultString, SolrRecord.class);
                ResearchProductHtml researchProductHtml = this.researchProductsHtmlMapper.toResearchProductHtml(solrRecord);
                htmlBuilder.append("<tr>").append("<td>").append(researchProductHtml.getType()).append("</td>").append("<td>").append(researchProductHtml.getTitle()).append("</td>").append("<td>").append(researchProductHtml.getAuthors()).append("</td>").append("<td>").append(researchProductHtml.getPublicationYear()).append("</td>").append("<td>").append(researchProductHtml.getDoi()).append("</td>").append("<td>").append(researchProductHtml.getPermanentIdentifier()).append("</td>").append("<td>").append(researchProductHtml.getPublicationType()).append("</td>").append("<td>").append(researchProductHtml.getJournal()).append("</td>").append("<td>").append(researchProductHtml.getProjectName_gaNumber()).append("</td>").append("<td>").append(researchProductHtml.getAccessMode()).append("</td>").append("</tr>");
            }
        }
        catch (Exception e) {
            log.error("Something went wrong with the HTML parsing.");
        }
        htmlBuilder.append("</tbody></table>");
        return htmlBuilder.toString();
    }
}

