/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary;

import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.AdminToolsProperties;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.GlobalVars;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.Google;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.Mail;
import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={AdminToolsProperties.class, GlobalVars.class})
@ComponentScan(basePackages={"eu.dnetlib.uoaadmintoolslibrary"})
@Import(value={AuthorizationConfiguration.class})
public class UoaAdminToolsLibraryConfiguration {
    private final Google google;
    private final Mail mail;
    private final GlobalVars globalVars;

    @Autowired
    public UoaAdminToolsLibraryConfiguration(AdminToolsProperties properties, GlobalVars globalVars) {
        this.google = properties.getGoogle();
        this.mail = properties.getMail();
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.google.getSecret() == null || this.google.getSecret().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.google.secret is missing!");
        }
        if (this.mail.getHost() == null || this.mail.getHost().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.mail.host is missing!");
        }
        if (this.mail.getAuth() == null || this.mail.getAuth().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.mail.auth is missing!");
        }
        if (this.mail.getPassword() == null || this.mail.getPassword().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.mail.password is missing!");
        }
        if (this.mail.getFrom() == null || this.mail.getFrom().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.mail.from is missing!");
        }
        if (this.mail.getPort() == null || this.mail.getPort().isEmpty()) {
            throw new RuntimeException("admintoolslibrary.mail.port is missing!");
        }
        if (this.mail.hasAuth()) {
            if (this.mail.getUsername() == null || this.mail.getUsername().isEmpty()) {
                throw new RuntimeException("admintoolslibrary.mail.username is missing!");
            }
            if (this.mail.getPassword() == null || this.mail.getPassword().isEmpty()) {
                throw new RuntimeException("admintoolslibrary.mail.password is missing!");
            }
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("admintoolslibrary.mail.auth", this.mail.getAuth());
        response.put("admintoolslibrary.mail.sslProtocols", this.mail.getSslProtocols());
        response.put("admintoolslibrary.mail.from", this.mail.getFrom());
        response.put("admintoolslibrary.mail.host", this.mail.getHost());
        response.put("admintoolslibrary.mail.port", this.mail.getPort());
        response.put("admintoolslibrary.mail.username", this.mail.getUsername());
        response.put("admintoolslibrary.mail.password", this.mail.getPassword());
        response.put("admintoolslibrary.google.secret", this.google.getSecret());
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

