/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Entity;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalEntity;
import eu.dnetlib.uoaadmintoolslibrary.services.EntityService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EntityController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private EntityService entityService;

    @RequestMapping(value={"/entity"}, method={RequestMethod.GET})
    public ResponseEntity<List<Entity>> getAllEntities() {
        return ResponseEntity.ok(this.entityService.getAllEntities());
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/entity/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalEntity> insertEntity(@RequestBody Entity entity) {
        return ResponseEntity.ok((Object)this.entityService.insertEntity(entity));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/entity/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalEntity> updateEntity(@RequestBody PortalEntity portalEntity) {
        return ResponseEntity.ok((Object)this.entityService.updateEntity(portalEntity));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/entity/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteEntities(@RequestBody List<String> entities) {
        return ResponseEntity.ok((Object)this.entityService.deleteEntities(entities));
    }
}

