/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.news.News;
import eu.dnetlib.uoaadmintoolslibrary.services.NewsService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{portalType}"})
public class NewsController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final NewsService service;

    @Autowired
    public NewsController(NewsService service) {
        this.service = service;
    }

    @RequestMapping(value={"/{pid}/news"}, method={RequestMethod.GET})
    public ResponseEntity<List<News>> getAllNews(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid) {
        return ResponseEntity.ok(this.service.getAllNews(portalType, pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.isCurator(#portalType), @AuthorizationService.isManager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/news/save"}, method={RequestMethod.POST})
    public ResponseEntity<News> saveNews(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @RequestBody News news) {
        return ResponseEntity.ok((Object)this.service.saveNews(portalType, pid, news));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.isCurator(#portalType), @AuthorizationService.isManager(#portalType, #pid))")
    @RequestMapping(value={"/{pid}/news/delete/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteNews(@PathVariable(value="portalType") PortalType portalType, @PathVariable(value="pid") String pid, @PathVariable(value="id") String id) {
        this.service.deleteNews(portalType, pid, id);
        return ResponseEntity.noContent().build();
    }
}

