/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalPage;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ForbiddenException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PageController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PageService pageService;
    @Autowired
    private PortalService portalService;
    @Autowired
    private RolesUtils rolesUtils;

    @RequestMapping(value={"/page/full"}, method={RequestMethod.GET})
    public ResponseEntity<List<PortalPage>> getPagesFull(@RequestParam(value="pid", required=false) String pid, @RequestParam(value="page_route", required=false) String page_route) {
        return ResponseEntity.ok(this.pageService.getPagesFull(this.portalService.getPortal(pid), page_route));
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public ResponseEntity<List<Page>> getAllPages(@RequestParam(value="pid", required=false) String pid, @RequestParam(value="page_route", required=false) String page_route, @RequestParam(value="with_positions", required=false) String with_positions) {
        return ResponseEntity.ok(this.pageService.getAllPages(this.portalService.getPortal(pid), page_route, with_positions));
    }

    @RequestMapping(value={"/page/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalPage> updatePage(@RequestBody PortalPage portalPage) {
        if (portalPage == null) {
            throw new NullPointerException("Update page: portalPage is null");
        }
        if (portalPage.getId() == null) {
            throw new MismatchingContentException("Update page: Page has no id.");
        }
        if (!this.rolesUtils.isPortalAdmin() || portalPage.getPortalPid() != null && this.rolesUtils.hasUpdateAuthority(portalPage.getPortalType(), portalPage.getPortalPid())) {
            throw new ForbiddenException("Update page: You are not authorized to update  a page for " + portalPage.getPortalType() + (String)(portalPage.getPortalPid() != null ? " : " + portalPage.getPortalPid() : ""));
        }
        Page existingPage = this.pageService.getPageByPortalAndRoute(this.portalService.getPortal(PortalType.valueOf(portalPage.getPortalType()), portalPage.getPortalPid()), portalPage.getRoute());
        if (existingPage != null && !existingPage.getId().equals(portalPage.getId())) {
            throw new MismatchingContentException("Update page: There is already a page (" + existingPage.getId() + ") with route: " + portalPage.getRoute() + " in " + portalPage.getPortalType() + (String)(portalPage.getPortalPid() != null ? " : " + portalPage.getPortalPid() : ""));
        }
        return ResponseEntity.ok((Object)this.pageService.updatePage(portalPage));
    }

    @RequestMapping(value={"/page/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalPage> insertPage(@RequestBody PortalPage portalPage) {
        if (portalPage.getId() != null) {
            throw new MismatchingContentException("Save page: Page has already an id: " + portalPage.getId());
        }
        if (!this.rolesUtils.isPortalAdmin() || portalPage.getPortalPid() != null && this.rolesUtils.hasUpdateAuthority(portalPage.getPortalType(), portalPage.getPortalPid())) {
            throw new ForbiddenException("Save page: You are not authorized to create a page for " + portalPage.getPortalType() + (String)(portalPage.getPortalPid() != null ? " : " + portalPage.getPortalPid() : ""));
        }
        Page existingPage = this.pageService.getPageByPortalAndRoute(this.portalService.getPortal(PortalType.valueOf(portalPage.getPortalType()), portalPage.getPortalPid()), portalPage.getRoute());
        if (existingPage != null) {
            throw new MismatchingContentException("Save page: There is already a page (" + existingPage.getId() + ") with route: " + portalPage.getRoute() + " in " + portalPage.getPortalType() + (String)(portalPage.getPortalPid() != null ? " : " + portalPage.getPortalPid() : ""));
        }
        return ResponseEntity.ok((Object)this.pageService.insertPage(portalPage));
    }

    @RequestMapping(value={"/page/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deletePages(@RequestBody List<String> pages) {
        return ResponseEntity.ok((Object)this.pageService.deletePages(pages));
    }

    @RequestMapping(value={"/page/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Page> getPage(@PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.pageService.getPage(id));
    }
}

