/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.Plugin;
import eu.dnetlib.uoaadmintoolslibrary.entities.plugin.PluginTemplate;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PluginService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PluginController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PluginService pluginService;
    @Autowired
    private PageService pageService;

    @RequestMapping(value={"/plugins"}, method={RequestMethod.GET})
    public ResponseEntity<List<Plugin>> getPlugins() {
        return ResponseEntity.ok(this.pluginService.getPlugins());
    }

    @RequestMapping(value={"/plugins/template/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<List<Plugin>> getPluginsByTemplate(@PathVariable(value="id") String id) {
        return ResponseEntity.ok(this.pluginService.getPluginsByTemplateId(id));
    }

    @RequestMapping(value={"/pluginTemplates"}, method={RequestMethod.GET})
    public ResponseEntity<List<PluginTemplate>> getPluginTemplates() {
        return ResponseEntity.ok(this.pluginService.getPluginTemplates());
    }

    @RequestMapping(value={"/pluginTemplates/page/{pageId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<PluginTemplate>> getPluginTemplatesByPage(@PathVariable(value="pageId") String pageId) {
        return ResponseEntity.ok(this.pluginService.getPluginTemplates(pageId));
    }

    @RequestMapping(value={"/pluginTemplates/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<PluginTemplate> getPluginTemplateById(@PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.pluginService.getPluginTemplateById(id));
    }

    @RequestMapping(value={"/plugin/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Plugin> getPluginById(@PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)this.pluginService.getPluginById(id));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/pluginTemplate/save"}, method={RequestMethod.POST})
    public ResponseEntity<PluginTemplate> insertTemplate(@RequestBody PluginTemplate pluginTemplate) {
        return ResponseEntity.ok((Object)this.pluginService.savePluginTemplate(pluginTemplate));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/pluginTemplate/save/order/{position}"}, method={RequestMethod.POST})
    public ResponseEntity<PluginTemplate> updatePluginTemplateOrder(@RequestBody PluginTemplate pluginTemplate, @PathVariable(value="position") Integer position) {
        PluginTemplate pt;
        pt.setOrder((pt = this.pluginService.getPluginTemplateById(pluginTemplate.getId())).getOrder() != null ? pt.getOrder() + position : 0);
        return ResponseEntity.ok((Object)this.pluginService.savePluginTemplate(pt));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type),@AuthorizationService.manager(#type, #pid))")
    @RequestMapping(value={"/{type}/{pid}/plugin/save/order/{position}"}, method={RequestMethod.POST})
    public ResponseEntity<Plugin> updatePluginOrder(@PathVariable(value="type") PortalType type, @PathVariable(value="pid") String pid, @RequestBody Plugin plugin, @PathVariable(value="position") Integer position) {
        Plugin pl;
        pl.setOrder((pl = this.pluginService.getPluginById(plugin.getId())).getOrder() != null ? pl.getOrder() + position : 0);
        return ResponseEntity.ok((Object)this.pluginService.savePlugin(pl));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type),@AuthorizationService.manager(#type, #pid))")
    @RequestMapping(value={"/{type}/{pid}/plugin/save"}, method={RequestMethod.POST})
    public ResponseEntity<Plugin> savePlugin(@PathVariable(value="type") PortalType type, @PathVariable(value="pid") String pid, @RequestBody Plugin plugin) {
        plugin.setPid(pid);
        return ResponseEntity.ok((Object)this.pluginService.savePlugin(plugin));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type),@AuthorizationService.manager(#type, #pid))")
    @RequestMapping(value={"/{type}/{pid}/plugin/status/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Plugin> updatePluginStatus(@PathVariable(value="type") PortalType type, @PathVariable(value="pid") String pid, @PathVariable(value="id") String id, @RequestBody String status) {
        return ResponseEntity.ok((Object)this.pluginService.updatePluginStatus(id, status));
    }

    @RequestMapping(value={"/pluginTemplate/page/count"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, Integer>> countPluginTemplatesForPages() {
        HashMap<String, Integer> mapCount = new HashMap<String, Integer>();
        for (Page page : this.pageService.getAllPages(null, null, null)) {
            mapCount.put(page.getId(), this.pluginService.getPluginTemplatesByPage(page).size());
        }
        return ResponseEntity.ok(mapCount);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/pluginTemplate/{id}"}, method={RequestMethod.DELETE})
    public void deletePluginTemplate(@PathVariable(value="id") String id) {
        this.pluginService.deletePluginTemplate(id);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/plugin/{id}"}, method={RequestMethod.DELETE})
    public void deletePlugin(@PathVariable(value="id") String id) {
        this.pluginService.deletePlugin(id);
    }

    @RequestMapping(value={"/plugin/template/count"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, Integer>> countPluginsByTemplate() {
        HashMap<String, Integer> mapCount = new HashMap<String, Integer>();
        List<PluginTemplate> templates = this.pluginService.getPluginTemplates();
        for (PluginTemplate template : templates) {
            mapCount.put(template.getId(), this.pluginService.getPluginsByTemplateId(template.getId()).size());
        }
        return ResponseEntity.ok(mapCount);
    }
}

